
// import './js/TopdataVariants_moveSlide.js';


// ---- our simple custom product slider

import SimpleProductSlider from './plugins/simple-product-slider';
import VariantSelector from './plugins/variant-selector';
import PayPalReinitializer from './plugins/paypal-reinitializer';

document.addEventListener('DOMContentLoaded', () => {
    // Initialize sliders for existing product boxes
    document.querySelectorAll('.card.product-box').forEach(el => {
        SimpleProductSlider.init(el);
    });

    // Initialize variant selector
    new VariantSelector();
    
    // Set up MutationObserver to catch new product boxes added by pagination or AJAX
    initializeMutationObserver();
});

// Initialize MutationObserver to detect dynamically added product boxes
function initializeMutationObserver() {
    // Create a new MutationObserver
    const observer = new MutationObserver((mutations) => {
        mutations.forEach((mutation) => {
            if (mutation.type === 'childList' && mutation.addedNodes.length > 0) {
                // Check each added node
                mutation.addedNodes.forEach((node) => {
                    // If it's an element node
                    if (node.nodeType === 1) {
                        // Initialize all product boxes within the added content
                        if (node.classList && node.classList.contains('card') && node.classList.contains('product-box')) {
                            SimpleProductSlider.init(node);
                        } else {
                            // Check for product boxes within the added node
                            const productBoxes = node.querySelectorAll('.card.product-box');
                            if (productBoxes.length > 0) {
                                productBoxes.forEach(box => {
                                    SimpleProductSlider.init(box);
                                });
                            }
                        }
                    }
                });
            }
        });
    });

    // Target node is the main content container 
    // This selector targets the common container in Shopware where product listings are updated
    const targetNode = document.querySelector('.cms-element-product-listing-wrapper, .product-listing');
    
    if (targetNode) {
        // Options for the observer
        const config = { childList: true, subtree: true };
        
        // Start observing
        observer.observe(targetNode, config);
    }
}

// Make helpers available globally
window.SimpleProductSlider = SimpleProductSlider;
window.PayPalReinitializer = PayPalReinitializer;

