<?php

namespace Topdata\TopdataVariantsInProductBoxesSW6\Controller;

use Maxia\MaxiaListingVariants6\Core\Content\Product\Cms\ProductListingCmsElementResolver;
use Maxia\MaxiaListingVariants6\Events\ProductBoxAjaxRenderEvent;
use Maxia\MaxiaListingVariants6\Service\ListingVariantsLoader;
use Monolog\Logger;
use Shopware\Core\Content\Cms\SalesChannel\SalesChannelCmsPageLoaderInterface;
use Shopware\Core\Content\Product\Events\ProductListingResultEvent;
use Shopware\Core\Content\Product\Exception\ProductNotFoundException;
use Shopware\Core\Content\Product\SalesChannel\Listing\AbstractProductListingRoute;
use Shopware\Core\Content\Product\SalesChannel\Listing\ProductListingLoader;
use Shopware\Core\Content\Product\SalesChannel\Listing\ProductListingResult;
use Shopware\Core\Content\Property\PropertyGroupCollection;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepositoryInterface;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Framework\Feature;
use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Storefront\Controller\StorefrontController;
use Shopware\Storefront\Page\GenericPageLoader;
use Shopware\Storefront\Page\GenericPageLoaderInterface;
use Shopware\Storefront\Page\Product\ProductPage;
use Shopware\Storefront\Page\Product\ProductPageLoadedEvent;
use Swag\PayPal\Checkout\ExpressCheckout\ExpressCheckoutSubscriber;
use Swag\PayPal\Checkout\ExpressCheckout\Service\ExpressCheckoutDataServiceInterface;
use Swag\PayPal\Checkout\ExpressCheckout\Service\PayPalExpressCheckoutDataService;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\Routing\Annotation\Route;
use Topdata\TopdataQueueHelperSW6\Util\UtilDebug;
use Topdata\TopdataVariantsInProductBoxesSW6\Service\ProductVariantsFetcher;

/**
 * 09/2024 created
 *
 * UNUSED AS AJAX FUNCTIONALITY IN THE LIST VIEWS BRINGS ALL KINDS OF PROBLEMS.
 *
 * @Route(defaults={"_routeScope"={"storefront"}})
 */
class MyAjaxController extends StorefrontController
{
    private ProductVariantsFetcher $productVariantsFetcher;
    private GenericPageLoaderInterface $genericLoader;
    private ExpressCheckoutDataServiceInterface $payPalExpressCheckoutDataService;


    public function __construct(
        EventDispatcherInterface         $eventDispatcher,
        GenericPageLoader                $genericPageLoader,
//        AbstractProductListingRoute        $listingRoute,
        EntityRepositoryInterface        $cmsSlotRepository,
        ProductListingLoader             $productListingLoader,
//        ListingVariantsLoader              $listingVariantsLoader,
        ProductVariantsFetcher           $productVariantsFetcher,
        GenericPageLoader                $genericLoader,
        PayPalExpressCheckoutDataService $payPalExpressCheckoutDataService
    )
    {
        $this->eventDispatcher = $eventDispatcher;
        $this->genericPageLoader = $genericPageLoader;
//        $this->listingRoute = $listingRoute;
        $this->cmsSlotRepository = $cmsSlotRepository;
        $this->productListingLoader = $productListingLoader;
//        $this->listingVariantsLoader = $listingVariantsLoader;
        $this->productVariantsFetcher = $productVariantsFetcher;
        $this->genericLoader = $genericLoader;
        $this->payPalExpressCheckoutDataService = $payPalExpressCheckoutDataService;
    }


    /**
     * 09/2024 created.
     *
     * @Route("/topdata-product-box/{productId}",
     *     name="topdata-variants-in-product-boxes-sw6.frontend.product-box",
     *     methods={"GET"},
     * )
     */
    public
    function getProductBoxAction(
        string              $productId,
        Request             $request,
        SalesChannelContext $salesChannelContext
    ): Response
    {
//        try {
            $product = $this->productVariantsFetcher->fetchProductWithGroupedVariants($productId, $salesChannelContext);
            $tdxExpressCheckoutButtonData = $this->payPalExpressCheckoutDataService->buildExpressCheckoutButtonData($salesChannelContext, true);
            return $this->renderStorefront('@Storefront/storefront/component/product/card/box.html.twig', [
                'tdxExpressCheckoutButtonData' => $tdxExpressCheckoutButtonData,
                'product'                     => $product,
            ]);
//        } catch(ProductNotFoundException $notFoundException){
//            throw new NotFoundHttpException($notFoundException->getMessage());
//        } //catch (\Exception $e) {
//            return new Response('Fehler/Error: ' . $e->getMessage(), Response::HTTP_INTERNAL_SERVER_ERROR);
//        }
////
//
//        $criteria = new Criteria([$productId]);
//        $request->request->set('order', 'id');
//        $criteria->addExtension('sortings', ProductListingCmsElementResolver::createSortings());
//
//        $product = $this->productVariantsFetcher->fetchProductWithGroupedVariants($productId, $salesChannelContext);
//
////        $result = $this->listingRoute
////            ->load($salesChannelContext->getSalesChannel()->getNavigationCategoryId(), $request, $salesChannelContext, $criteria)
////            ->getResult();
////
////        if (!$result->getEntities() || !$result->getEntities()->count()) {
//        // try to load without specific category
////            $criteria = $this->getCriteria($request, $salesChannelContext);
//        $result = $this->productListingLoader->load($criteria, $salesChannelContext);
//
//        if (!$result->getEntities() || !$result->getEntities()->count()) {
//            throw new ProductNotFoundException($productId);
//        }
//
//        $result = ProductListingResult::createFrom($result);
//
//        $this->eventDispatcher->dispatch(
//            new ProductListingResultEvent($request, $result, $salesChannelContext)
//        );
//
//        // ---- hack for paypal express checkout button BEGIN
////        $page = $this->genericLoader->load($request, $salesChannelContext);
////        /** @var ProductPage $page */
////        $page = ProductPage::createFrom($page);
////        $page->setProduct($product);
////        $page->setNavigationId($productId);
////
////
////        $event = new ProductPageLoadedEvent($page, $salesChannelContext, $request);
////        $this->eventDispatcher->dispatch($event);
////        $xxx = $event->getPage();
//        $xxx = $this->payPalExpressCheckoutDataService->buildExpressCheckoutButtonData($salesChannelContext, true);
////        dd("dsfdfdsfdsfdsfewdsfdsfdsf", $xxx);
//        // ---- hack for paypal express checkout button END
//
////        }
//
////        $this->listingVariantsLoader->load([$result->getEntities()->first()], $salesChannelContext);
//
//        $params = [
//            'product'     => $result->getEntities()->first(),
//            'layout'      => $request->query->get('layout'),
//            'displayMode' => $request->query->get('displayMode')
//        ];
//
//        $event = new ProductBoxAjaxRenderEvent($params['product'], $request, $params, $salesChannelContext);
//        $this->eventDispatcher->dispatch($event);
//
//        return $this->renderStorefront(
//            '@Storefront/storefront/component/product/card/box.html.twig',
//            $event->getParameters()
//        );

    }


    /**
     * 09/2024 created. but UNUSED.
     *
     * @Route("/topdata-bueromaterialien-product-variant-selector/{productId}",
     *     name="topdata-bueromaterialien.frontend.product-variant-selector",
     *     methods={"GET"},
     * )
     */
    public
    function getProductVariantSelectorAction(string $productId, SalesChannelContext $salesChannelContext): Response
    {
        try {
            $product = $this->productVariantsFetcher->fetchProductWithGroupedVariants($productId, $salesChannelContext);

            return $this->render('@Bueromaterialien/storefront/component/product/_topdata-variant-selector-v2.html.twig', [
                'product' => $product,
            ]);
        } catch (\Exception $e) {
            return new Response('Error: ' . $e->getMessage(), Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }

}