<?php


namespace Topdata\TopdataVariantsInProductBoxesSW6\Twig;


use Shopware\Core\Content\Product\ProductEntity;
use Shopware\Core\Content\Product\SalesChannel\SalesChannelProductEntity;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;


/**
 * 09/2024 created
 */
class MyTwigExtension extends AbstractExtension
{



    public function getFunctions(): array
    {
        return [
            new TwigFunction('TopdataVariantsInProductBoxesSW6_getBestProductIdForOption', [$this, 'TopdataVariantsInProductBoxesSW6_getBestProductIdForOption']),
        ];
    }


    /**
     * 09/2024 created
     * @param array $option the option for which the best product id should be found, e.g. ["optionName" => "50.000 Blatt / 1/2 Palette", "variants" => [0 => ["id" => "863b83515a0948a2adabc614076575af", "available" => true, "stock" => 643, "seoUrl" => "/Kopierpapier-Palette-Navigator-Universal-8247A80B-DIN-A4-80-g-qm-weiss-Palette-mit-100.000-Blatt/599919HPAL"]]]
     * @param ProductEntity|SalesChannelProductEntity $currentProduct currently displayed product
     * @param array $groupedVariants the grouped variants of the current product, format see below
     */
    public function TopdataVariantsInProductBoxesSW6_getBestProductIdForOption(array $option, $currentProduct, array $groupedVariants): string
    {
//        == example for $option:
//array:2 [▼
//  "optionName" => "50.000 Blatt / 1/2 Palette"
//  "variants" => array:1 [▼
//    0 => array:4 [▼
//      "id" => "863b83515a0948a2adabc614076575af"
//      "available" => true
//      "stock" => 643
//      "seoUrl" => "/Kopierpapier-Palette-Navigator-Universal-8247A80B-DIN-A4-80-g-qm-weiss-Palette-mit-100.000-Blatt/599919HPAL"
//    ]
//  ]
//]
//
//
//        == example for $groupedVariants:
//array:1 [▼
//  "5e5b4aec7b7f4c6e9eedd61188dd2bcc" => array:2 [▼
//    "groupName" => "Inhalt"
//    "options" => array:2 [▼
//      "eaa839fa90b94605bb6f26bceca553c0" => array:2 [▼
//        "optionName" => "50.000 Blatt / 1/2 Palette"
//        "variants" => array:1 [▼
//          0 => array:4 [▼
//            "id" => "863b83515a0948a2adabc614076575af"
//            "available" => true
//            "stock" => 643
//            "seoUrl" => "/Kopierpapier-Palette-Navigator-Universal-8247A80B-DIN-A4-80-g-qm-weiss-Palette-mit-100.000-Blatt/599919HPAL"
//          ]
//        ]
//      ]
//      "92d5e46f35bc49a0a041202c8c6157c2" => array:2 [▼
//        "optionName" => "100.000 Blatt / 1 Palette"
//        "variants" => array:1 [▼
//          0 => array:4 [▼
//            "id" => "c7358aefe38e40db93f1218334ec5edc"
//            "available" => true
//            "stock" => 903
//            "seoUrl" => "/Kopierpapier-Palette-Navigator-Universal-8247A80B-DIN-A4-80-g-qm-weiss-Palette-mit-100.000-Blatt/599919PAL"
//          ]
//        ]
//      ]
//    ]
//  ]
//]


        // ------------------------------------------------
        // ---- search for the best product id,


        $possibleProductIds = array_column($option["variants"], "id");
        if(count($possibleProductIds) == 1) {
            return $possibleProductIds[0];
        }
        if(count($possibleProductIds) == 0) {
            throw new \LogicException("Fffffffucck");
        }

        // hotfix: random element... FIXME!!
        return $possibleProductIds[array_rand($possibleProductIds)];

        // ==== try 1:
        //   return the exact product id if it is available: matching the options of the current product:
        //     iterate over the variants of the current product



        // ==== try 2:
        //   return the first available product id: matching the options of the current product:

    }


}
