<?php declare(strict_types=1);

namespace Topdata\TopdataVariantsInProductBoxesSW6\Subscriber;

use Shopware\Core\Content\Product\Events\ProductListingResultEvent;
use Shopware\Core\Content\Product\Events\ProductSearchResultEvent;
use Shopware\Core\System\SalesChannel\Entity\SalesChannelEntitySearchResultLoadedEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Topdata\TopdataVariantsInProductBoxesSW6\Service\ProductVariantsFetcher;

/**
 * 09/2024 created
 */
class MyEventSubscriber implements EventSubscriberInterface
{


    private ProductVariantsFetcher $productVariantsFetcher;

    public function __construct(
        ProductVariantsFetcher $productVariantsFetcher
    )
    {
        $this->productVariantsFetcher = $productVariantsFetcher;
    }

    public static function getSubscribedEvents(): array
    {
        return [
            ProductSearchResultEvent::class              => 'onProductSearchResult',
            ProductListingResultEvent::class             => 'onProductListingResult',
            'sales_channel.product.search.result.loaded' => 'onSalesChannelProductSearchResultLoaded',
//            'product.search.result.loaded'               => 'onSearchResult',
//            SalesChannelEntitySearchResultLoadedEvent::class => 'onSearchResult',
//            'product.search.request'         => 'onProductSearch'
//            EntitySearchedEvent::class       => 'onEntitySearchedEvent',
        ];
    }

    /**
     * this one is for sisi search
     */
    public function onSalesChannelProductSearchResultLoaded(SalesChannelEntitySearchResultLoadedEvent $event): void
    {
//        // Check if we're already processing this event to prevent infinite recursion
//        static $isProcessing = false;
//        if ($isProcessing) {
//            return;
//        }
//
//        $isProcessing = true;
//        try {
//            $this->productVariantsFetcher->loadMany($event->getResult()->getEntities()->getElements(), $event->getSalesChannelContext());
//        } finally {
//            $isProcessing = false;
//        }

        static $depth = 0;
        if ($depth > 0) { // Allow up to 1 levels of recursion
            return;
        }

        $depth++;
        try {
            $this->productVariantsFetcher->loadMany($event->getResult()->getEntities()->getElements(), $event->getSalesChannelContext());
        } finally {
            $depth--;
        }
    }


//    public function onProductSearch(EntitySearchedEvent $event): void
//    {
//        file_put_contents('/tmp/MyEventSubscriber_onProductSearch.txt', "....\n");
//    }

//    public function onEntitySearchedEvent(EntitySearchedEvent $event): void
//    {
//        file_put_contents('/tmp/MyEventSubscriber_onEntitySearchedEvent.txt', "....\n");
//        $event->getCriteria()->addAssociation('media');
//    }

    public function logAllEvents($event): void
    {
//        file_put_contents('/tmp/all_events.log', get_class($event) . PHP_EOL, FILE_APPEND);
    }

    public function onProductSearchResult(ProductSearchResultEvent $event): void
    {
//        file_put_contents('/tmp/MyEventSubscriber_onProductSearchResult.txt', "....\n");
    }


    public function onProductListingResult(ProductListingResultEvent $event): void
    {
//        file_put_contents('/tmp/MyEventSubscriber_onProductListingResult.txt', "....\n");
        $products = $event->getResult()->getEntities()->getElements();
        $this->productVariantsFetcher->loadMany($products, $event->getSalesChannelContext());
    }


}
