<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Storefront\Page\OneBrandLetter;

use Shopware\Storefront\Page\Page;
use Topdata\TopdataTopFinderProSW6\Component\BreadcrumbsTrait;

/**
 * This class represents the structure of the one brand letter page.
 * It extends the base Page class and includes properties for devices, brand, series and types.
 */
class OneBrandLetterPage extends Page
{
    use BreadcrumbsTrait;

    public array $popupPath;

    /**
     * @var string
     */
    protected $title;

    /**
     * @var array
     */
    public $devices;
    public $brand;
    public $series;
    public $types;

    public int $initialLoadLimit;
    public int $devicesTotal = 0;
    public array $devicesBySeriesTotal = []; // Must be an array
    public array $devicesByTypeTotal = []; // Must be an array

    public string $brandLetter;
    public string $brandName;
    public string $brandUrl;
    public string $seriesName;
    public string $seriesUrl;
    public string $typeName;
    public string $typeUrl;
    public string $currentView;
    public string $currentUrl;
    public string $canonicalUrl;
    public array $breadcrumbItems = [];
    public array $viewUrls = [];
    public array $metaData = [];

    public array $seriesList = [];
    public array $typesList = [];
    public array $devicesBySeries = [];
    public array $devicesByType = [];

    public function getTitle(): string
    {
        return $this->title;
    }

    public function setTitle(string $value): void
    {
        $this->title = $value;
    }
}