// @ts-ignore - Shopware Storefront imports
import Plugin from 'src/plugin-system/plugin.class';
// @ts-ignore - Shopware Storefront imports
import DomAccess from 'src/helper/dom-access.helper';
// @ts-ignore - Shopware Storefront imports
import HttpClient from 'src/service/http-client.service';
// @ts-ignore - Shopware Storefront imports
import Iterator from 'src/helper/iterator.helper';

interface PluginOptions {
    snippets?: {
        loading?: string;
    };
}

export default class TopdataTopFinderProBrandPage extends Plugin {
    private _client!: HttpClient;
    private _radioGroup!: HTMLElement;
    private _contentContainers!: NodeListOf<HTMLElement>;
    public el!: HTMLElement;
    public options!: PluginOptions;

    init() {
        console.log("TopdataTopFinderProBrandPage init");
        this._client = new HttpClient();
        
        try {
            this._radioGroup = DomAccess.querySelector(this.el, '[data-brand-page-radio-group]');
            this._contentContainers = DomAccess.querySelectorAll(this.el, '[data-brand-page-content-wrapper]');
        } catch (e) {
            console.warn('Brand page plugin initialization failed:', e);
            return;
        }

        this._registerEvents();
    }

    private _registerEvents() {
        console.log("TopdataTopFinderProBrandPagePlugin _registerEvents");
        // --- Event for Toggling Views (No Grouping, Series, Type) ---
        const radioButtons = this._radioGroup.querySelectorAll('input[type="radio"]');
        Iterator.iterate(radioButtons, (radio: HTMLInputElement) => {
            radio.addEventListener('change', this._onGroupingChange.bind(this));
        });

        // --- Delegated Event for all "Load More" buttons ---
        this.el.addEventListener('click', this._onLoadMoreClick.bind(this));
    }

    private _onGroupingChange(event: Event) {
        console.log("TopdataTopFinderProBrandPage _onGroupingChange");
        const targetRadio = event.currentTarget as HTMLInputElement;
        const selectedValue = targetRadio.value;

        this._contentContainers.forEach((container) => {
            const containerValue = DomAccess.getAttribute(container, 'data-brand-page-content-wrapper');
            container.classList.toggle('d-none', containerValue !== selectedValue);
        });
    }

    private _onLoadMoreClick(event: Event) {
        console.log("TopdataTopFinderProBrandPage _onLoadMoreClick");
        const target = event.target as HTMLElement;
        const loadMoreButton = target.closest('.load-more-devices') as HTMLButtonElement;

        if (!loadMoreButton) {
            return;
        }

        event.preventDefault();
        const originalButtonText = loadMoreButton.innerHTML;
        loadMoreButton.disabled = true;
        loadMoreButton.innerHTML = `<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> ${this.options?.snippets?.loading || 'Loading...'}`;

        const brandCode = DomAccess.getAttribute(loadMoreButton, 'data-brand-code');
        const offset = DomAccess.getAttribute(loadMoreButton, 'data-offset');
        const grouping = DomAccess.getAttribute(loadMoreButton, 'data-grouping');
        const groupValue = DomAccess.getAttribute(loadMoreButton, 'data-group-value', false) || '';
        const targetContainerSelector = DomAccess.getAttribute(loadMoreButton, 'data-target-container');

        if (!targetContainerSelector) {
            console.error('Load more button is missing "data-target-container" attribute.');
            loadMoreButton.disabled = false;
            loadMoreButton.innerHTML = 'Error';
            return;
        }
        
        let url = `/top-finder-api/brand/${brandCode}/load-more?offset=${offset}&grouping=${grouping}`;
        if (groupValue) {
            url += `&groupValue=${encodeURIComponent(groupValue)}`;
        }
        
        this._client.get(url, (responseText: string, request: XMLHttpRequest) => {
            loadMoreButton.disabled = false;
            loadMoreButton.innerHTML = originalButtonText;

            if (request.status >= 400) {
                console.error('Failed to load more devices:', responseText);
                loadMoreButton.innerHTML = 'Error loading more';
                return;
            }

            try {
                const response = JSON.parse(responseText);
                if (response.success && response.html) {
                    const container = DomAccess.querySelector(document, targetContainerSelector);
                    if (container) {
                        container.insertAdjacentHTML('beforeend', response.html);
                    }

                    if (response.hasMore) {
                        loadMoreButton.setAttribute('data-offset', response.newOffset);
                    } else {
                        loadMoreButton.remove();
                    }
                } else if (!response.success) {
                    console.error('Server returned error:', response.message || 'Unknown error');
                    loadMoreButton.innerHTML = 'Error loading more';
                }
            } catch (error) {
                console.error("Error parsing Load More response:", error);
                loadMoreButton.innerHTML = 'Error loading more';
            }
        });
    }
}