---
title: Configuration & Settings
---

All settings for the Topdata TopFinder Pro plugin can be found in your Shopware Admin under `Extensions > My extensions > ... > Configure`. The configuration is divided into several sections for clarity.

### Select Boxes

This section controls the main finder bar displayed in your storefront.

- **Choose the select boxes that should be displayed**: Defines the structure of the finder.
  - **Options**:
    - `Brands - Series - Devices`: A three-step selection process.
    - `Brands - Types - Devices`: An alternative three-step process.
    - `Brands - Types/Series - Devices`: (Default) A three-step process with a toggle to switch between Series and Types.
    - `Brands - Devices`: A simplified two-step process.
- **Show selectboxes**: Determines where the finder bar appears.
  - **Options**: `on all pages` (Default), `only on Topfinder pages`, `don't show`.
- **Display "brand / series / type" page after selection**: If enabled, selecting an option (e.g., a brand) will navigate the user to that brand's page instead of just loading the next dropdown. Default: `Disabled`.
- **Show device history**: If enabled, a dropdown with recently viewed devices is shown in the finder bar. Default: `Enabled`.
- **Allow user to hide select boxes**: If enabled, users can collapse the finder bar. Default: `Enabled`.
- **Dropdowns Column Class**: Enter the Bootstrap column classes to control the layout of the dropdowns (e.g., `col-sm-4 col-md` for horizontal layout, `col-sm-12` for vertical). Default: `col-sm-4 col-md`.
- **Loading spinner display mode**: How the loading indicator is shown during AJAX requests.
  - **Options**: `None`, `Overlay` (Default).
- **Position of the finder bar**: Controls where the finder bar is rendered on the page.
  - **Options**: `Top of page (above header)` (Default), `Above main navigation (below search bar)`, `Below main navigation`.

### Devices Brand Letters

This controls the A-Z navigation bar.

- **Show letters**: Toggles the visibility of the A-Z navigation bar. Default: `Enabled`.
- **Show devices instead of brands by search via letters**: If enabled, clicking a letter shows a list of devices. If disabled, it shows a list of brands. Default: `Disabled`.
- **Disable empty letters**: If enabled, letters with no associated brands/devices are grayed out and unclickable. Default: `Enabled`.

### Devices History and Slider

This controls the device history functionality.

- **Number of devices on device history**: How many recently viewed devices are stored. Default: `10`.
- **Show device history on all pages**: If enabled, a slider of recently viewed devices appears in the storefront. Default: `Enabled`.
- **Hide slider with device history**: If enabled, users can hide the device history slider. Default: `Enabled`.

### Device Finder Popup

This controls the modal-based finder.

- **Show an additional popup with device finder**: Toggles the button in the header that opens the popup. Default: `Enabled`.
- **Choose the select boxes of the device finder...**: Sets the dropdown structure inside the popup (same options as the main finder bar). Default: `Brands - Types/Series - Devices`.
- **Show device history**: Toggles the history feature inside the popup. Default: `Enabled`.
- **Color Settings**: A series of color pickers (`Background dark`, `Background light`, etc.) to customize the visual appearance of the popup finder to match your theme.

### Product Details Page

This controls features on the product detail page.

- **Display a tab with "compatible devices"**: Toggles the "Compatible Devices" tab. Default: `Enabled`.
- **Mode of grouping the devices**: How devices are grouped within the tab.
  - **Options**: `Group by series` (Default), `Group by brand`, `No grouping`.
- **Mode of compatible device names**: How device names are formatted in lists.
  - **Options**: `device`, `brand + device` (Default), `brand + new line + device`.
- **Show sub navigation** (`fixProductBreadcrumbs`): Adjusts the breadcrumb trail on product pages for better context. Default: `Enabled`.

### Search

This controls the device search integration.

- **Printer Search Input**:
  - **Options**:
    - `Combined with productsearch` (Default): Device search results are shown alongside regular product search results.
    - `Separate searchfield`: A separate search bar for devices is displayed.
    - `Disabled`: Device search is disabled.
- **If no device found. Don't display Result**: Hides the device results section in the combined search if no devices are found. Default: `Enabled`.

### User "Device List"

This controls the feature for logged-in customers.

- **Activate personal device list**: Enables the "My Device List" feature, allowing logged-in customers to save their devices. Default: `Enabled`.

### Display devices in compact mode

These settings define the threshold at which a full-detail view switches to a more compact list view to save space.

- **Number on search results**: Default `10`.
- **Number on device list**: Default `10`.
- **Number on product detail page**: Default `3`.

### Device details page

This controls the product listings on the automatically generated device pages.

- **Property to group products by tabs**: Allows you to select a product property group (e.g., "Condition"). Products on the device page will be separated into tabs based on the values of this property (e.g., a tab for "Original" and a tab for "Compatible").
- **Default product sorting**: Sets the default sort order for products on device pages. Default: `Topseller`.
- **Products per page**: Sets the number of products to show per page. Default: `10`.
- **Css Class For Product Box In Product List**: Enter the Bootstrap column classes to control the product grid layout on device pages. Default: `col-sm-6 col-lg-4 col-xl-3`.

### Device Availability

This setting controls how the system treats devices from the Topdata catalog that are not linked to any products in your shop after an import. This is particularly useful for controlling which devices appear in the TopFinder.

- **Device Availability Strategy**:
  - **Options**:
    - `Disable devices without products (Default)`: This is the standard behavior. After a product-device link import, any device, brand, series, or type that is not associated with at least one product will be disabled and will not appear in the storefront finder.
    - `Keep all devices enabled`: Select this option if you want all devices from the Topdata catalog to remain active and visible in the finder, regardless of whether they are linked to products in your shop. This can be useful if you want to show customers your full range of supported devices, even if the corresponding products are not yet available.

### Cart Settings

- **Show last used compatible device in cart**: If enabled, when a customer adds a product to the cart, the system will show which of their recently viewed devices this product is compatible with. This provides extra confirmation for the customer. Default: `Disabled`.
