<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Framework\Cookie;

use Shopware\Storefront\Framework\Cookie\CookieProviderInterface;

/**
 * Provides cookie definitions for the Topdata TopFinder Pro plugin.
 * It decorates the original Shopware CookieProviderInterface to add its own cookies.
 * 04/2025 TODO: use CookieKeyNameConstants
 * 04/2025 TODO: are these cookies used anywhere?
 */
class TopFinderCookieProvider implements CookieProviderInterface
{
    public function __construct(
        /**
         * @var CookieProviderInterface The original cookie provider service being decorated.
         */
        private CookieProviderInterface $originalService
    )
    {
    }

    /**
     * Defines the cookie group and individual cookies required by the TopFinder plugin.
     * These cookies store user preferences related to device history and filter states.
     */
    private const cookieGroup = [
        'isRequired'          => true, // These cookies are essential for the finder functionality.
        'snippet_name'        => 'topdata-topfinder.cookie.groupName',
        'snippet_description' => 'topdata-topfinder.cookie.groupDescription',
        'entries'             => [
            [
                'snippet_name' => 'topdata-topfinder.cookie.deviceHistoryName',
                'cookie'       => 'topdata-device-history', // Stores the user's device selection history.
                'value'        => '',
                'expiration'   => '30', // Cookie expiration in days.
            ],
            [
                'snippet_name' => 'topdata-topfinder.cookie.deviceSelectboxesStateName',
                'cookie'       => 'topdata-device-selectboxes', // Stores the state of selectbox filters.
                'value'        => '',
                'expiration'   => '30',
            ],
            [
                'snippet_name' => 'topdata-topfinder.cookie.deviceSliderStateName',
                'cookie'       => 'topdata-device-slider', // Stores the state of slider filters.
                'value'        => '',
                'expiration'   => '30',
            ],
            [
                'snippet_name' => 'topdata-topfinder.cookie.deviceSwitchStateName',
                'cookie'       => 'topdata-switch', // Stores the state of switch filters.
                'value'        => '',
                'expiration'   => '30',
            ],
        ],
    ];

    /**
     * Returns a list of all cookie groups, merging the original Shopware cookies
     * with the custom TopFinder cookies defined in this provider.
     *
     * @return array An array containing all cookie group definitions.
     */
    public function getCookieGroups(): array
    {
        // ---- Merge original cookies with TopFinder cookies
        return array_merge(
            $this->originalService->getCookieGroups(),
            [
                self::cookieGroup,
            ]
        );
    }
}