# Topdata TopFinder Pro for Shopware 6

## Description

Topdata TopFinder Pro is a comprehensive Shopware 6 plugin designed to enhance product discovery, particularly for stores selling items compatible with specific devices, such as printer ink, toner, or accessories. It provides customers with an intuitive "finder" interface to select their device (e.g., printer model) via a series of dropdowns, A-Z navigation, or a search bar, and then displays a list of all compatible products.

The plugin is highly configurable, allowing shop administrators to control the appearance, placement, and behavior of all frontend components to perfectly match their store's needs.

## Key Features

- **Configurable Finder Bar:** Display a device finder with dropdowns for Brand, Series, and Type directly in the storefront.
- **Flexible Placement:** Position the finder bar above the header, or above or below the main navigation.
- **A-Z Navigation:** Allow customers to browse brands or devices alphabetically.
- **Popup Finder:** An alternative, modal-based finder that can be launched from any page.
- **Device Pages:** Automatically generates SEO-friendly landing pages for each Brand, Series, Type, and Device, listing all compatible products.
- **Configurable Product Listings:** Control the default sorting, pagination, and layout of product lists on device pages.
- **Product Tabs:** Group products on device pages into tabs based on product properties (e.g., "Original", "Compatible").
- **"Compatible Devices" Tab:** Adds a tab to product detail pages showing a list of all devices the product works with.
- **Search Integration:** Integrates device search directly into the main shop search bar or provides a separate search field.
- **"My Device List":** Allows logged-in customers to save their devices for quick and easy access to compatible products in the future.
- **Device History:** Displays recently viewed devices in a dropdown or a storefront slider.
- **Cart Integration:** Optionally displays the last-used compatible device next to products in the shopping cart.
- **CMS Block:** Includes a Shopware Shopping Experiences block to place the finder anywhere on CMS pages.

## Documentation

For detailed installation and configuration instructions, please refer to the files in the `manual/` directory.

## Plugin Interaction

When both `TopdataTopFinderProSW6` and `TopdataTopFeedSW6` are installed and active, this plugin's "Compatible Devices" tab takes priority. The corresponding tab from `TopdataTopFeedSW6` will be automatically hidden to prevent duplication in the storefront.
