import HttpClient from 'src/service/http-client.service';
import PluginManager from 'src/plugin-system/plugin.manager';
import CookieStorage from 'src/helper/storage/cookie-storage.helper';



//const PluginManager = window.PluginManager;

/*
 * load functionality of separate search box
 */
import TopdataTopFinderProSearchDevice from './plugin/topdata-top-finder-pro.search-device.plugin';

PluginManager.register(
    'TopdataTopFinderProSearchDevice',
    TopdataTopFinderProSearchDevice,
    '[data-search-device-form]'
);


// ====================================================


const TOP_FINDER_SELECTOR = '.top-finder-';
const POPUP_TIMEOUT = 750;
const LOAD_PAGE_CLASS = 'top-finder-load-page-1';

var brandsLoading = 1,
    seriesLoading = 1,
    typesLoading = 1,
    devicesLoading = 1,
    popupHistory = [];
    
window.popupDeviceReturnPath = '';

var exists = function(el) {
    return (el.length !== 0);
};

var topFinderActionConfirmed = false;
var confirmFunction = function() {console.log('empty function!');};

$(document).on('click', "#top-finder-confirm-dialog-yes", function() {
    confirmFunction();
});

var popupHistoryAdd = function(path) {
    let lastPath = popupHistory.pop();
    if((path !== lastPath) && lastPath) {
        popupHistory.push(lastPath);
    }
    popupHistory.push(path);
    $('.topdata-finder-popup-back').removeClass('inactive');
};

$(document).on('click', '[data-confirm]',function(event) {
    if(topFinderActionConfirmed) {
        return;
    }
    event.stopImmediatePropagation();
    var button = $(this);
    $("#top-finder-confirm-dialog-text").text($(this).data('confirm'));
    
    confirmFunction = function(){
        $("#top-finder-modal-confirm-dialog").find('.modal-close').first().click();
        topFinderActionConfirmed = true;
        button.trigger("click");
        if(button.attr('href') && button.attr('href') !== '#') {
            window.location.href = button.attr('href');
        }
        topFinderActionConfirmed = false;
        return false;
    };
    
    $('#top-finder-modal-confirm-dialog-popup-trigger').click();
    
    return false;
});

var deviceListHttpClient;
var popupDeviceBoxTimeout;
var popupDeviceBoxHttpClient;
var productDevicesPopupHttpClient = new HttpClient(window.accessKey, window.contextToken);
var suggestPopupHttpClient;
var suggestPopupText = '';

var popupButtonDevicesEnable = function(path) {
    var button = $('.topdata-finder-popup-button-devices');
    button.data("path", path);
    button.removeClass('inactive');
};

var popupButtonDevicesDisable = function() {
    var button = $('.topdata-finder-popup-button-devices');
    button.data("path", '');
    button.addClass('inactive');
};

var popupButtonProductsEnable = function(path) {
    var button = $('.topdata-finder-popup-button-products');
    button.attr("href", path);
    button.removeClass('inactive');
};

var popupButtonProductsDisable = function() {
    var button = $('.topdata-finder-popup-button-products');
    button.attr("href", 'javascript:;');
    button.addClass('inactive');
};

var popupButtonsListReset = function() {
    $('.topdata-finder-popup-button-devicelist-remove')
        .removeClass('top-finder-remove-device')
        .addClass('hidden')
        .addClass('inactive');

    $('.topdata-finder-popup-button-devicelist-add')
        .removeClass('top-finder-add-device')
        .removeClass('hidden')
        .addClass('inactive');
};

var fillSelect = function(select, selectItems, selectValue) {
    reset(select);
    $.each(selectItems , function(key,value) {
        if(selectValue == key) {
            select.append($('<option selected="true"></option>')
             .attr("value", key).text(value));
        }
        else {
            select.append($("<option></option>")
             .attr("value", key).text(value));
        }
    });
};

var setPopupMode = function(mode) {
    popupButtonDevicesDisable();
    popupButtonProductsDisable();
    popupButtonsListReset();

    $('.topdata-finder-popup-reset').removeClass('inactive');
    $('.topdata-finder-popup-menu .popup-menu-series-types').addClass('inactive');
    
    if(mode == 'abc') {
        $('.topdata-finder-popup-mode-abc-trigger').addClass('hidden');
        $('.topdata-finder-popup-mode-selectboxes-trigger').removeClass('hidden');
        $('.topdata-finder-popup-mode-search-trigger').removeClass('hidden');

        $('.topdata-finder-popup-content-left.top-finder-selectboxes').addClass('hidden');
        $('.topdata-finder-popup-content-left.top-finder-abc').removeClass('hidden');
        $('.topdata-finder-popup-content-left.top-finder-popup-search').addClass('hidden');
        
        $('.topdata-finder-popup-content-right')
            .html($('.topdata-finder-popup-content-abc-empty').first().clone());
        
        return;
    }
    
    if(mode == 'search') {
        $('.topdata-finder-popup-mode-abc-trigger').removeClass('hidden');
        $('.topdata-finder-popup-mode-selectboxes-trigger').removeClass('hidden');
        $('.topdata-finder-popup-mode-search-trigger').addClass('hidden');

        $('.topdata-finder-popup-content-left.top-finder-selectboxes').addClass('hidden');
        $('.topdata-finder-popup-content-left.top-finder-abc').addClass('hidden');
        $('.topdata-finder-popup-content-left.top-finder-popup-search').removeClass('hidden');
        
        $('.topdata-finder-popup-content-right')
            .html($('.topdata-finder-popup-content-search-empty').first().clone());
        
        return;
    }
    
    //selectboxes mode
    $('.topdata-finder-popup-menu .popup-menu-series-types').removeClass('inactive');
    $('.topdata-finder-popup-mode-abc-trigger').removeClass('hidden');
    $('.topdata-finder-popup-mode-selectboxes-trigger').addClass('hidden');
    $('.topdata-finder-popup-mode-search-trigger').removeClass('hidden');
    
    $('.topdata-finder-popup-content-left.top-finder-selectboxes').removeClass('hidden');
    $('.topdata-finder-popup-content-left.top-finder-abc').addClass('hidden');
    $('.topdata-finder-popup-content-left.top-finder-popup-search').addClass('hidden');
    
    $('.topdata-finder-popup-content-right')
            .html($('.topdata-finder-popup-content-empty').first().clone());
};

var popupResetAll = function() {
    brandsLoading = true;
    seriesLoading = true;
    typesLoading = true;
    devicesLoading = true;
    window.popupDeviceReturnPath = '';
    setPopupMode('select');
    popupButtonDevicesDisable();
    popupButtonProductsDisable();
    popupButtonsListReset();
    $('.topdata-finder-popup-reset').addClass('inactive');
    $('.topdata-finder-popup-back').addClass('inactive');
    popupHistory = [];
    $('.popup-search-input-container input').val('');
    
    $('.topdata-finder-popup-menu .popup-menu-series-types').removeClass('inactive');
    
    if (typeof window.slimselects.popupBrands !== "undefined") {
        window.slimselects.popupBrands.set(null);
    }
    
    if (typeof window.slimselects.popupTypes !== "undefined") {
        window.slimselects.popupTypes.set(null);
        window.slimselects.popupTypes.disable();
        $('.topdata-finder-popup-content-left div.top-finder-types').hide();
        $('.topdata-finder-popup-content-left .empty-types-link').show();
    }
    
    if (typeof window.slimselects.popupSeries !== "undefined") {
        window.slimselects.popupSeries.set(null);
        window.slimselects.popupSeries.disable();
        $('.topdata-finder-popup-content-left div.top-finder-series').hide();
        $('.topdata-finder-popup-content-left .empty-series-link').show();
    }
    
    if (typeof window.slimselects.popupDevices !== "undefined") {
        window.slimselects.popupDevices.set(null);
        window.slimselects.popupDevices.disable();
        $('.topdata-finder-popup-content-left div.top-finder-devices').hide();
        $('.topdata-finder-popup-content-left .empty-devices-link').show();
    }
    
    if (typeof window.slimselects.popupHistoryDevices !== "undefined") {
        window.slimselects.popupHistoryDevices.set(null);
    }
    
    if (typeof window.slimselects.popupDevicelistDevices !== "undefined") {
        window.slimselects.popupDevicelistDevices.set(null);
    }
    
    brandsLoading = false;
    seriesLoading = false;
    typesLoading = false;
    devicesLoading = false;
};

var popupResetABC = function() {
    
};

$(document).on('click', TOP_FINDER_SELECTOR + 'show-list-products', function(e) {
    e.stopImmediatePropagation();
    var elements = $(this).closest('.modal-body').find('input[name="product-id"]');
    if(elements.length === 0) {
        return false;
    }
    var path=$(this).data('path');
    path += "?ids=";
    elements.each(function(key,el) {
        var id = $(el).val();
        if(id) {
            path += (key>0)?'-'+id:id;
        }
    });
    window.location.href = path;
    return false;
});

$(document).on('mouseenter', '[data-showdevice]', function() {
    var $self = $(this);
    var path = $self.data('path');
    popupDeviceBoxTimeout = setTimeout(function() {
        var $popup = $self.find('.top-finder-popup-devicebox');
        if (typeof popupDeviceBoxHttpClient === 'undefined') {
            popupDeviceBoxHttpClient = new HttpClient(window.accessKey, window.contextToken);
        }
        popupDeviceBoxHttpClient.abort();
                
        if(exists($popup)) {
            $popup.show();
        }
        else {
            $self.append($('<span class="top-finder-popup-devicebox"></span>'));
            popupDeviceBoxHttpClient.get(path, (response) => {
                $self.find('.top-finder-popup-devicebox').html(response).addClass('loaded');
            });
        }
    }, POPUP_TIMEOUT);
});

$(document).on('mouseleave', '[data-showdevice]', function() {
    clearTimeout(popupDeviceBoxTimeout);
    $(this).find('.top-finder-popup-devicebox').hide();
});

$(document).on('click', TOP_FINDER_SELECTOR+'search-devicelist-trigger', function() {
    var keyword = $(TOP_FINDER_SELECTOR+'search-devicelist-input').val();
    var path = $(this).data('path');
    if((keyword.length < 3) && (keyword.length !== 0)) {
        return;
    }
    var container = $(TOP_FINDER_SELECTOR+'device-list-container');
    if (typeof deviceListHttpClient === 'undefined') {
        deviceListHttpClient = new HttpClient(window.accessKey, window.contextToken);
    }
    deviceListHttpClient.abort();
    
    container.css('opacity', '0.5').css('pointer-events', 'none');
    
    deviceListHttpClient.get(path + "?keyword=" + keyword, (response) => {
        container.html(response);
        container.css('opacity', '1').css('pointer-events', 'all');
        if(keyword.length >2) {
            $(TOP_FINDER_SELECTOR+'search-devicelist-reset').show();
        }
    });
});

$(document).on('click', TOP_FINDER_SELECTOR+'search-devicelist-reset', function() {
    $(this).hide();
    $(TOP_FINDER_SELECTOR+'search-devicelist-input').val('');
    $(TOP_FINDER_SELECTOR+'search-devicelist-trigger').trigger('click');
});

$(TOP_FINDER_SELECTOR+'search-devicelist-input').on('keydown', function(e) {
    if (e.which === 13) {
        $(TOP_FINDER_SELECTOR+'search-devicelist-trigger').trigger('click');
    }
});

$(document).on('click', TOP_FINDER_SELECTOR+'edit-device-info', function() {
    $(TOP_FINDER_SELECTOR+'popup-info-trigger-'+$(this).data('id')).first().trigger('click');
    return false;
});

$(document).on('click', TOP_FINDER_SELECTOR+'device-list-device-item-delete', function() {
    $(this).closest(TOP_FINDER_SELECTOR+'form-device-info').remove();
    return false;
});

$(document).on('click', TOP_FINDER_SELECTOR+'expand-info', function() {
    var className = TOP_FINDER_SELECTOR+'hidden';
    $(this).closest('table').find(TOP_FINDER_SELECTOR+'hiddable').toggleClass(className.substr(1));
    
    return false;
});

$(document).on('click', TOP_FINDER_SELECTOR+'device-list-device-info-save', function() {
    var form = $(this).closest('form');
    var httpClient = new HttpClient(window.accessKey, window.contextToken);
    var data = {
        deviceId: form.find('input[name="deviceId"]').val(),
        formData: {
            devices: []
        }
    };
    
    var xdevices = form.find(TOP_FINDER_SELECTOR+'items-container .form-row');
    $.each(xdevices, function(key,value) {
        var name = $(value).find('input[name="formData[name][]"]').val();
        var number = $(value).find('input[name="formData[number][]"]').val();
        var location = $(value).find('input[name="formData[location][]"]').val();
        var user = $(value).find('input[name="formData[user][]"]').val();
        var notes = $(value).find('input[name="formData[notes][]"]').val();
        data.formData.devices.push({
            name,
            number,
            location,
            user,
            notes
        });
    });
    
    if (window.csrf.enabled && window.csrf.mode === 'twig') {
        data['_csrf_token'] = form.find('input[name="_csrf_token"]').val();
    }
    
    form.css('opacity', '0.5').css('pointer-events', 'none');
    
    httpClient.post( form.attr('action'), JSON.stringify(data), (response) => {
        response = JSON.parse(response);
        if(response['success'] === true) {
            form.closest('.modal').find('.modal-close').first().trigger('click');
            $(TOP_FINDER_SELECTOR+'search-devicelist-trigger').trigger('click');
        }
        else {
            form.css('opacity', '1').css('pointer-events', 'all');
        }
    });
    return false;
});

$(document).on('click', TOP_FINDER_SELECTOR+'device-list-device-item-add', function() {
    var container = $(this).closest('form').find(TOP_FINDER_SELECTOR+'items-container');
    var className = TOP_FINDER_SELECTOR+'form-device-info-empty';
    var emptyElement = $(this).closest('form').find(className);
    emptyElement.clone().removeClass(className.substr(1)).appendTo(container);
    return false;
});

$(document).on('click', TOP_FINDER_SELECTOR + 'slider-close', function() {
    $(TOP_FINDER_SELECTOR + 'slider-not-hiddable').show();
    $(TOP_FINDER_SELECTOR + 'slider-hiddable').hide();
    CookieStorage.setItem('topdata-device-slider', 'hidden', 30);
});

$(document).on('click', TOP_FINDER_SELECTOR + 'slider-show', function() {
    $(TOP_FINDER_SELECTOR + 'slider-hiddable').show();
    $(TOP_FINDER_SELECTOR + 'slider-not-hiddable').hide();
    CookieStorage.setItem('topdata-device-slider', '');
    return false;
});

$(document).on('click', TOP_FINDER_SELECTOR + 'selectboxes-hide', function() {
    $(this).closest(TOP_FINDER_SELECTOR + 'selectboxes').addClass('top-finder-selectboxes-hidden');
    CookieStorage.setItem('topdata-device-selectboxes', 'hidden', 30);
    return false;
});

$(document).on('click', TOP_FINDER_SELECTOR + 'selectboxes-show', function() {
    $(this).closest(TOP_FINDER_SELECTOR + 'selectboxes').removeClass('top-finder-selectboxes-hidden');
    CookieStorage.setItem('topdata-device-selectboxes', '', 30);
    return false;
});

$(document).on('click', TOP_FINDER_SELECTOR+'close-modal', function() {
    $(this).closest('.modal').find('.modal-close').first().click();
});




$(document).on('click', TOP_FINDER_SELECTOR+'product-devices-load-popup', function() {
    var path = $(this).data('path');
    var containerHeader = $('#product-devices-popup .modal-title');
    var container = $('#product-devices-popup .modal-body');
    productDevicesPopupHttpClient.abort();
    productDevicesPopupHttpClient.get(path, (response) => {
        response = JSON.parse(response);
        if(response.success === true) {
            container.html(response.html);
            containerHeader.html(response.title);
            $('#product-devices-popup-trigger').click();
        }
    });
    return false;
});

var popupLoadDevice = function(path, container) {
    container = $(container).first();
    container.find('[data-toggle="tooltip"]').tooltip('dispose');
    animateLoading(container);
    var httpClient = new HttpClient(window.accessKey, window.contextToken);
    httpClient.get(path, (response) => {
        popupHistoryAdd(path);
        response = JSON.parse(response);
        container.html(response.html);
        popupButtonProductsEnable(response.deviceUrl);
        if(response.userLogged) {
            if(response.inDeviceList) {
                $('.topdata-finder-popup-button-devicelist-remove')
                    .addClass('top-finder-remove-device')
                    .data('path', response.pathListRemove)
                    .removeClass('hidden')
                    .removeClass('inactive');
            
                $('.topdata-finder-popup-button-devicelist-add')
                    .addClass('top-finder-add-device')
                    .data('path', response.pathListAdd)
                    .addClass('hidden')
                    .addClass('inactive');
            }
            else {
                $('.topdata-finder-popup-button-devicelist-remove')
                    .addClass('top-finder-remove-device')
                    .data('path', response.pathListRemove)
                    .addClass('hidden')
                    .addClass('inactive');
            
                $('.topdata-finder-popup-button-devicelist-add')
                    .addClass('top-finder-add-device')
                    .data('path', response.pathListAdd)
                    .removeClass('hidden')
                    .removeClass('inactive');
            }
            
        }
        else {
            popupButtonsListReset();
        }
        container.find('[data-toggle="tooltip"]').tooltip();
        $('.topdata-finder-popup-reset').removeClass('inactive');
        if(window.popupDeviceReturnPath) {
            container.find('.return')
                    .removeClass('top-finder-hidden')
                    .data('path', window.popupDeviceReturnPath);
        }
    });
};

$(document).on('change', 'select' + TOP_FINDER_SELECTOR + 'device-popup-new', function(event) {
    event.stopImmediatePropagation();
    var device_code = $(this).val();
    window.popupDeviceReturnPath = '';
    if(device_code == 0 || device_code === '' || device_code === null || device_code === $(this).data('placeholder')) {
        return false;
    }
    var path = $(this).data('path')
            + "?deviceCode="
            + device_code
            + '&listType='
            + $(this).data('listtype');
    
    popupLoadDevice(path, '.topdata-finder-popup-content-right');
    
    var pathlisdevices = $(this).data('pathlisdevices');
    if(pathlisdevices) {
        popupButtonDevicesEnable(pathlisdevices);
    }
    
    return false;
});


$(document).on('change', 'select' + TOP_FINDER_SELECTOR + 'device-popup', function(event) {
    event.stopImmediatePropagation();
    var device_code = $(this).val();
    var path = $(this).data('path');
    var device_container;
    if($(this).hasClass('device-list')) {
        device_container = $(TOP_FINDER_SELECTOR+'popup-device-list-container');
    }
    else {
        device_container = $(TOP_FINDER_SELECTOR+'popup-device-finder-container');
    }
    device_container.html( $(TOP_FINDER_SELECTOR+'loading-animation').first().html() );
    if(device_code === '') {
        return false;
    }
    var httpClient = new HttpClient(window.accessKey, window.contextToken);
    httpClient.get(path+"?deviceCode=" + device_code, (response) => {
        device_container.html(response);
    });
    return false;
});

var loaded = function(data, select) {
    data = JSON.parse(data);
    var length = 0;
    $.each(data.items, function(key,value) {
        select.append($("<option></option>")
         .attr("value", key).text(value));
        length = length+1; 
    });
};

var reset = function(el) {
    if(exists(el)) {
        el.empty();
        el.append($("<option></option>")
            .data("placeholder", el.data('placeholder'))
            .attr('value', '0')
            .text(el.data('placeholder')));
        el.val(null);
    }
    return el;
};

$(document).on('change','select'+TOP_FINDER_SELECTOR+'brand',function() {
    if(brandsLoading) {
        return;
    }
    var path = '';
    var brand_id = $(this).val();
        
    if(brand_id === '' || brand_id === null || brand_id == 0) {
        popupButtonDevicesDisable();
        return;
    }
    
    if($(this).hasClass(LOAD_PAGE_CLASS)) {
        path = $(this).data('pathgotobrand');
        window.location.href = path.replace('brandcode', brand_id);
        return;
    }
    
    var enableSelects = false;
    
    if($(this).parents('.topdata-finder-popup')) {
        path = $(this).data('pathgotobrand');
        path = path.replace('brandcode', brand_id);
        popupButtonDevicesEnable(path);
        enableSelects = true;
        $('.topdata-finder-popup-reset').removeClass('inactive');
    }
    
    var httpClient = new HttpClient(window.accessKey, window.contextToken);
    var parent = $(this).closest('.top-finder-selectboxes');
    var series_select = parent.find('select'+TOP_FINDER_SELECTOR+'series');
    var types_select = parent.find('select'+TOP_FINDER_SELECTOR+'types');
    var devices_select = parent.find('select'+TOP_FINDER_SELECTOR+'devices');    
    
    if(exists(types_select)) {
        typesLoading = 1;
        reset(types_select);
        path = $(this).data('pathloadtypes');
        httpClient.get(path.replace('brandcode', brand_id), (response) => {
            typesLoading = 0;
            loaded(response, types_select);
            if (enableSelects && (typeof window.slimselects.popupTypes !== "undefined")) {
                $('.topdata-finder-popup-content-left div.top-finder-types').show();
                window.slimselects.popupTypes.enable();
                $('.topdata-finder-popup-content-left .empty-types-link').hide();
            }
        });        
    }
    
    if(exists(series_select)) {
        seriesLoading = 1;
        reset(series_select);
        path = $(this).data('pathloadseries');
        httpClient.get(path.replace('brandcode', brand_id), (response) => {
            seriesLoading = 0;
            loaded(response, series_select);
            if (enableSelects && (typeof window.slimselects.popupSeries !== "undefined")) {
                $('.topdata-finder-popup-content-left div.top-finder-series').show();
                window.slimselects.popupSeries.enable();
                $('.topdata-finder-popup-content-left .empty-series-link').hide();
            }
        });
    }
    
    devicesLoading = 1;
    reset(devices_select);
    path = $(this).data('pathloaddevices');
    httpClient.get(path.replace('brandcode', brand_id), (response) => {
        devicesLoading = 0;
        loaded(response, devices_select);
        if (enableSelects && (typeof window.slimselects.popupDevices !== "undefined")) {
            $('.topdata-finder-popup-content-left div.top-finder-devices').show();
            window.slimselects.popupDevices.enable();
            $('.topdata-finder-popup-content-left .empty-devices-link').hide();
            devices_select.data('listtype', 'brand');
        }
    });
});


$(document).on('change','select'+TOP_FINDER_SELECTOR+'switch',function() {
    var parent = $(this).closest('.top-finder-selectboxes');
    CookieStorage.setItem('topdata-switch', $(this).val(), 30);
    if($(this).hasClass('top-finder-load-page-1')) {
        var brand_id = parent.find('select'+TOP_FINDER_SELECTOR+'brand').val();
        var path = parent.find('select'+TOP_FINDER_SELECTOR+'brand').data('pathgotobrand');
        window.location.href = path.replace('brandcode', brand_id);
        return;
    }
    
    if($(this).val() === 'types') {
        parent.find(TOP_FINDER_SELECTOR+'series-container').hide();
        parent.find(TOP_FINDER_SELECTOR+'types-container').show();
    }
    else {
        parent.find(TOP_FINDER_SELECTOR+'series-container').show();
        parent.find(TOP_FINDER_SELECTOR+'types-container').hide();
    }
});

$(document).on('change','select'+TOP_FINDER_SELECTOR+'types',function() {
    if(typesLoading) {
        return;
    }
    var types_id = $(this).val();
    var path = '';
    var parent = $(this).closest('.top-finder-selectboxes');
    var devices_select = parent.find('select'+TOP_FINDER_SELECTOR+'devices');
    
    reset(devices_select);
    if(types_id === '' || types_id === null || types_id == 0) {
        if($(this).parents('.topdata-finder-popup')) {
            let brandSelector = parent
                    .find('select'+TOP_FINDER_SELECTOR+'brand')
                    .first();
            path = brandSelector
                    .data('pathgotobrand')
                    .replace('brandcode', brandSelector.val());
            popupButtonDevicesEnable(path);
        }
        return;
    }
    
    if($(this).hasClass(LOAD_PAGE_CLASS)) {
        path = $(this).data('pathgototype');
        window.location.href = path.replace('typecode', types_id);
        return;
    }
    
    if($(this).parents('.topdata-finder-popup')) {
        path = $(this).data('pathgototype');
        path = path.replace('typecode', types_id);
        popupButtonDevicesEnable(path);
        devices_select.data('listtype', 'types');
    }
    
    var brand_id = parent.find('select'+TOP_FINDER_SELECTOR+'brand').val();
    var httpClient = new HttpClient(window.accessKey, window.contextToken);
    
    devicesLoading = 1;
    path = $(this).data('pathloaddevices');
    path = path.replace('brandcode', brand_id);
    path = path.replace('typecode', types_id);
    httpClient.get(path, (response) => {
        devicesLoading = 0;
        loaded(response, devices_select);
    });
});

$(document).on('change','select'+TOP_FINDER_SELECTOR+'series',function() {
    if(seriesLoading) {
        return;
    }
    var series_id = $(this).val();
    var path = '';
    var parent = $(this).closest('.top-finder-selectboxes');
    var devices_select = parent.find('select'+TOP_FINDER_SELECTOR+'devices');
    reset(devices_select);
    if(series_id === '' || series_id === null || series_id == 0) {
        if($(this).parents('.topdata-finder-popup')) {
            let brandSelector = parent
                    .find('select'+TOP_FINDER_SELECTOR+'brand')
                    .first();
            path = brandSelector
                    .data('pathgotobrand')
                    .replace('brandcode', brandSelector.val());
            popupButtonDevicesEnable(path);
        }
        return;
    }
    
    if($(this).hasClass(LOAD_PAGE_CLASS)) {
        path = $(this).data('pathgotoseries');
        path = path.replace('seriescode', series_id);
        window.location.href = path;
        return;
    }
    
    if($(this).parents('.topdata-finder-popup')) {
        path = $(this).data('pathgotoseries');
        path = path.replace('seriescode', series_id);
        popupButtonDevicesEnable(path);
        devices_select.data('listtype', 'series');
    }
    
    var brand_id = parent.find('select'+TOP_FINDER_SELECTOR+'brand').val();
    var httpClient = new HttpClient(window.accessKey, window.contextToken);
    
    devicesLoading = 1;
    path = $(this).data('pathloaddevices');
    path = path.replace('brandcode', brand_id);
    path = path.replace('seriescode', series_id);
    httpClient.get(path, (response) => {
        devicesLoading = 0;
        loaded(response, devices_select);
    });
});


 // Users Device List functionality

var deviceAdded = function(data) {
    $(TOP_FINDER_SELECTOR+'add-device').data('loading', 'false');
    data = JSON.parse(data);
    if(data.success===true) {
        $(TOP_FINDER_SELECTOR+'add-device-'+data.deviceId).hide();
        $(TOP_FINDER_SELECTOR+'remove-device-'+data.deviceId).show();
        $(TOP_FINDER_SELECTOR+'devicelist-device-'+data.deviceId).show();
        $(TOP_FINDER_SELECTOR+'device-list-icon-'+data.deviceId).show();
        
    
        $('.topdata-finder-popup-device-add-list-'+data.deviceId).addClass('top-finder-hidden');
        $('.topdata-finder-popup-device-show-list-'+data.deviceId).removeClass('top-finder-hidden');
        $('.topdata-finder-popup-device-remove-list-'+data.deviceId).removeClass('top-finder-hidden');
        
        let container = $('.topdata-finder-popup-content-right').first();
        if(exists(container.find('.device-box'))) {
            container.find('.device-box .device-list-'+data.deviceId).removeClass('top-finder-hidden');
            
            $('.topdata-finder-popup-button-devicelist-remove')
                .removeClass('hidden')
                .removeClass('inactive');

            $('.topdata-finder-popup-button-devicelist-add')
                .addClass('hidden')
                .addClass('inactive');
        }
    }
};

var deviceRemoved = function(data) {
    $(TOP_FINDER_SELECTOR+'remove-device').data('loading', 'false');
    data = JSON.parse(data);
    if(data.success===true) {
        $(TOP_FINDER_SELECTOR+'add-device-'+data.deviceId).show();
        $(TOP_FINDER_SELECTOR+'remove-device-'+data.deviceId).hide();
        $(TOP_FINDER_SELECTOR+'devicelist-device-'+data.deviceId).hide();
        $(TOP_FINDER_SELECTOR+'device-list-icon-'+data.deviceId).hide();
        $(TOP_FINDER_SELECTOR+'user-device-list '+TOP_FINDER_SELECTOR+'device-'+data.deviceId).remove();
        
        $('.topdata-finder-popup-content-abc-devices .devicelist-device-'+data.deviceId).remove();
        
        $('.topdata-finder-popup-device-add-list-'+data.deviceId).removeClass('top-finder-hidden');
        $('.topdata-finder-popup-device-show-list-'+data.deviceId).addClass('top-finder-hidden');
        $('.topdata-finder-popup-device-remove-list-'+data.deviceId).addClass('top-finder-hidden');
        
        let container = $('.topdata-finder-popup-content-right').first();
        if(exists(container.find('.device-box'))) {
            $('.topdata-finder-popup-button-devicelist-remove')
                .addClass('hidden')
                .addClass('inactive');

            $('.topdata-finder-popup-button-devicelist-add')
                .removeClass('hidden')
                .removeClass('inactive');
        
            window.popupDeviceReturnPath = '';
            container.find('.return')
                .addClass('top-finder-hidden')
                .data('path', '');
        
            container.find('.device-box .device-list-'+data.deviceId).html('0').addClass('top-finder-hidden');
        }
        
    }
};


$(document).on('click',TOP_FINDER_SELECTOR+'add-device',function() {
    if($(this).data('loading') === 'true') {
        return;
    }
    var path = $(this).data('path');
    var httpClient = new HttpClient(window.accessKey, window.contextToken);
    $(this).data('loading', 'true');
    httpClient.get(path, deviceAdded);
});

$(document).on('click',TOP_FINDER_SELECTOR+'remove-device',function() {
    if($(this).data('loading') === 'true') {
        return false;
    }
    
    var path = $(this).data('path');
    var httpClient = new HttpClient(window.accessKey, window.contextToken);
    $(this).data('loading', 'true');
    httpClient.get(path, deviceRemoved);
    return false;
});


$(document).on('click',TOP_FINDER_SELECTOR+'hiddable-trigger',function() {
    var group = $(this).data('group');
    if(group) {
        $(TOP_FINDER_SELECTOR+'hiddable[data-group="'+group+'"]').toggleClass('hidden');
    }
    else {
        $(TOP_FINDER_SELECTOR+'hiddable').toggleClass('hidden');
    }
});

$(document).on('click',TOP_FINDER_SELECTOR+'toggle-class', function() {
    var toggleClass = $(this).data('class');
    var target = $(this).data('target');
    if(target && toggleClass) {
        $(target).toggleClass(toggleClass);
    }
});

$(document).on('click','.topdata-finder-popup .modal-body', function(e) {
    var target = $(this).find('.topdata-finder-popup-menu.opened');
    if(target) {
        $(target).removeClass("opened");
    }
    
    $(this).find('.device-menu-content.opened').removeClass("opened");
});

$(document).on('click', TOP_FINDER_SELECTOR+'brand-devices-load-tab', function() {
    var className = TOP_FINDER_SELECTOR+'brand-devices-load-tab';
    $(this).removeClass(className.substr(1));
    var path = $(this).data('path');
    var tabPaneSelector = $(this).attr('href');
    var container = $(tabPaneSelector).find('.topfinder-devices-compact');
    var httpClient = new HttpClient(window.accessKey, window.contextToken);
    httpClient.get(path, (response) => {
        response = JSON.parse(response);
        if(response.success === true) {
            container.html(response.html);
            window.PluginManager.initializePlugins();
        }
    });
});

if(exists(TOP_FINDER_SELECTOR+'load-more')) {
    
    $(document).on('click', TOP_FINDER_SELECTOR+'load-more', function() {
        var path = $(this).data('path');
        var container = $(this);
        var httpClient = new HttpClient(window.accessKey, window.contextToken);
        $(this).addClass('loading');
        httpClient.get(path, (response) => {
            response = JSON.parse(response);
            if(response.success === true) {
                container.replaceWith(response.html);
                window.PluginManager.initializePlugins();
            }
        });
    });

    $(window).scroll(function() {
        let el = $(TOP_FINDER_SELECTOR+'load-more');
        if(exists(el) && (el.hasClass('loading') == false)) {
            let windowBottom = $(window).scrollTop()+$(window).height();
            let elOffset = el.offset().top;
            if(windowBottom > elOffset) {
                el.trigger('click');
            }
        }
    });
}


function makeid(length) {
    var result           = '';
    var characters       = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    var charactersLength = characters.length;
    for ( var i = 0; i < length; i++ ) {
      result += characters.charAt(Math.floor(Math.random() * 
 charactersLength));
   }
   return result;
}

// Importing SlimSelect


var script = document.createElement('script');
window.slimselects = {};
script.onload = function () {
    $.each($(TOP_FINDER_SELECTOR + 'slimselect'), function(key, el) {
        let ident = makeid(10);
        if($(el).data('slimselectid')) {
            ident = $(el).data('slimselectid');
        }
        var addToBody = $(el).hasClass('add-to-body');
        var showSearch = !addToBody;
        if (typeof window.slimselects[ident] !== 'undefined') {
            ident = ident + '2';
        }
        
        
        if($(el).hasClass('top-finder-switch')) {
            window.slimselects[ident] = new SlimSelect({
              select: el,
              addToBody: addToBody,
              showSearch: false
            });
        }
        else if($(el).hasClass('slimselect-addable')) {
            window.slimselects[ident] = new SlimSelect({
                select: el,
                addToBody: addToBody,
                showSearch: showSearch,
                addable: function (value) {
                    let val = $.trim(value);
                    if(val.length < 3) {
                        return false;
                    }
                    return {
                        text: val,
                        value: encodeURIComponent(val)
                    };
                }
            });            
        }
        else {
            window.slimselects[ident] = new SlimSelect({
                select: el,
                addToBody: addToBody,
                showSearch: showSearch
            });
        }
        window.slimselects[ident].disable();
        window.slimselects[ident].enable();
        
    });
};
script.src = 'https://cdnjs.cloudflare.com/ajax/libs/slim-select/1.26.0/slimselect.min.js';

document.head.appendChild(script);

$(document).ready(function() {
    brandsLoading = 0;
    seriesLoading = 0;
    typesLoading = 0;
    devicesLoading = 0;
    
    var devicesTabSelector = $('.top-finder-brand-devices-load-tab');
    if(devicesTabSelector.length) {
        devicesTabSelector.first().trigger("click");
    }
});

var offcanvasDeviceTimer;
var offcanvasDeviceTrigger = $('.top-finder-offcanvas-device-trigger');
var offvanvasDevice = $('.top-finder-offcanvas-device');

if(exists(offcanvasDeviceTrigger) && exists(offvanvasDevice)) {
    $(window).scroll(function() {
        clearTimeout(offcanvasDeviceTimer);
        offcanvasDeviceTimer = setTimeout(function() {
            var offcanvasDeviceOffset = offcanvasDeviceTrigger.offset().top - 20;
            var scrollHeigh = $(window).scrollTop();
            if(scrollHeigh > offcanvasDeviceOffset) {
                offvanvasDevice.removeClass('top-finder-hidden');
            }
            else {
                offvanvasDevice.addClass('top-finder-hidden');
            }
        }, 150);
    });
}


$(document).on('click', '.topdata-finder-popup .empty-content-show-link',function() {
    var contentBlock = $(this).data('content');
    
    if(!contentBlock) {
        return;
    }
    
    if(seriesLoading || typesLoading || devicesLoading) {
        return;
    }
    
    var container = $(this)
            .closest('.modal-content')
            .find('.topdata-finder-popup-content-right')
            .first();
    
    var content = $(this)
            .closest('.modal-content')
            .find(contentBlock)
            .first()
            .clone();
    
    container.html(content);
    $('.topdata-finder-popup-reset').removeClass('inactive');
});



// Slider buttons
$(document).on('click', '.topdata-finder-popup-slider-buttons-button',function() {
    $(this)
        .addClass('selected')
        .siblings()
        .removeClass('selected');

    $(this)
        .parents('.topdata-finder-popup-slider')
        .first()
        .find('.topdata-finder-popup-slide')
        .removeClass('selected');

    $(this)
        .parents('.topdata-finder-popup-slider')
        .first()
        .find( $(this).data('target') )
        .addClass('selected');
});


$(document).on('click', '.topdata-finder-popup-button-devicelist-show', function() {
    popupButtonProductsDisable();
    popupButtonsListReset();
    $('.topdata-finder-popup-reset').removeClass('inactive');
});

$(document).on('click', '.topdata-finder-popup-reset', function() {
    if($(this).hasClass('inactive')) {
        return;
    }
    popupResetAll();
});

$(document).on('click', '.topdata-finder-popup-reset-abc', function() {
    popupResetABC();
});


$(document).on('click', '.topdata-finder-popup-device', function() {
    var path = $(this).data('path');
    console.log(path);
    if(!path) {
        return;
    }
    popupLoadDevice(path, '.topdata-finder-popup-content-right');
});

$(document).on('click', '.topdata-finder-popup-mode-abc-trigger', function() {
    setPopupMode('abc');
});

$(document).on('click', '.topdata-finder-popup-mode-selectboxes-trigger', function() {
    setPopupMode('select');
});

$(document).on('click', '.topdata-finder-popup-mode-search-trigger', function() {
    setPopupMode('search');
});


$(document).on('mouseenter', '.topdata-finder-popup-content-right .popup-device-image', function() {
    var imageBlock = $(this).clone();
    var container = $(this)
                    .parents('.topdata-finder-popup')
                    .find('.topdata-finder-popup-content-left')
                    .not('.hidden')
                    .first();
    imageBlock.appendTo(container);
    
    setTimeout(function() {
        imageBlock.addClass('shown');
    }, 20);
    
});


$(document).on('mouseleave', '.popup-device-image', function() {
    $(this)
        .parents('.topdata-finder-popup')
        .find('.topdata-finder-popup-content-left .popup-device-image')
        .remove();
});


$(document).on('click', '.topdata-finder-popup-button-devices', function() {
    popupButtonProductsDisable();
    popupButtonsListReset();
    $('.topdata-finder-popup-reset').removeClass('inactive');
});

var animateLoading = function(container) {
    container.append( $('.topdata-finder-popup-loading-animation').first().clone() );
};

var popupLoadMoreDevices = function(path) {
    var container = $('.topdata-finder-popup-content-right').first();
    productDevicesPopupHttpClient.abort();
    productDevicesPopupHttpClient.get(path, (response, fullResponse) => {
        let contentType = fullResponse.getResponseHeader('content-type');
        let success = true;
        let responseHtml = '';
        if(contentType === 'application/json') {
            response = JSON.parse(response);
            success = response.success;
            responseHtml = response.html;
        }
        else {
            responseHtml = response;
        }
        if(success === true) {
            container.find('.topdata-finder-popup-content-abc-devices').first().append(responseHtml);
        };
    });
};

$(document).on('click', '.popup-navigate-right', function(e) {
    if($(this).hasClass('inactive')) {
        return;
    }
    var path = $(this).data('path');
    if(!path) {
        return;
    }
    
    popupNavigateRight(path);
    popupHistoryAdd(path);
    
    popupButtonProductsDisable();
    popupButtonsListReset();
    $('.topdata-finder-popup-reset').removeClass('inactive');
});

$(document).on('click', '.devicelist-subdevice-delete', function() {
    return false;
});

$(document).on('keyup change paste', '#popupEditSubdeviceForm input, #popupEditSubdeviceForm  textarea', function() {
    $(this)
        .parents('.devicelist-device-subdevice-form')
        .find('.popup-form-apply')
        .removeClass('inactive');
});

$(document).on('click', '.popup-form-apply', function() {
    if($(this).hasClass('inactive')) {
        return;
    }
    var formSelector = $(this).data('form');
    if(!formSelector) {
        return;
    }
    var form = $(formSelector).first();
    var httpClient = new HttpClient(window.accessKey, window.contextToken);
    
    var formUnindexed = form.serializeArray();
    var data = {};

    $.map(formUnindexed, function(n, i){
        data[n['name']] = n['value'];
    });
    
    var container = $('.topdata-finder-popup-content-right').first();
    animateLoading(container);
    httpClient.post( form.attr('action'), JSON.stringify(data), (response) => {
        response = JSON.parse(response);
        if(response['success'] === true) {
            container.html(response.html);
        }
        else {
            console.log(response);
        }
    });
    
});

$(document).on('click', '.topfinder-stop-propagation', function(e) {
    if($(e.target).is("a") && $(e.target).attr('href') && !($(e.target).attr('href')=='javascript:;' || $(e.target).attr('href')=='#')) {
        window.location = $(e.target).attr('href');
    }
    e.stopPropagation();
    return false;
});



$(document).on('click', '.topfinder-popup-devicelist-mode', function() {
    if($(this).data('listmode') == 'min') {
        $(this).data('listmode', 'full');
        $('.topdata-finder-popup-content-abc-devices')
            .removeClass('mode-min')
            .addClass('mode-full');
        CookieStorage.setItem('topfinder-popup-devicelist-mode', 'full', 30);
    }
    else {
        $(this).data('listmode', 'min');
        $('.topdata-finder-popup-content-abc-devices')
            .addClass('mode-min')
            .removeClass('mode-full');
        CookieStorage.setItem('topfinder-popup-devicelist-mode', 'min', 30);
    }
});

$(document).on('mouseenter', '.device-box .prev, .device-box .next', function() {
    $('.device-box .number').addClass('show');
});

$(document).on('mouseleave', '.device-box .prev, .device-box .next', function() {
    $('.device-box .number').removeClass('show');
});

$(document).on('click', '.popup-search-input-container .input-group-append', function() {
    var input = $(this).siblings('input').first();
    var term = input.val();
    if(term.length < 3) {
        return;
    }
    var container = $('.topdata-finder-popup-content-right').first();
    var path = input.data('path') + '?term=' + term;
    container.find('[data-toggle="tooltip"]').tooltip('dispose');
    animateLoading(container);
    productDevicesPopupHttpClient.abort();
    productDevicesPopupHttpClient.get(path, (response, responseFull) => {
        let returnPath = responseFull.getResponseHeader('returnPath');
        let loadOffset = responseFull.getResponseHeader('loadOffset');
        container.html(response);
        if(returnPath) {
            window.popupDeviceReturnPath = returnPath;
        }
        container.find('[data-toggle="tooltip"]').tooltip();
        if(loadOffset) {
            if(path.indexOf('?')>=0) {
                popupLoadMoreDevices(path + '&offset=' + loadOffset);
            }
            else {
                popupLoadMoreDevices(path + '?offset=' + loadOffset);
            }
        }
    });
    popupHistoryAdd(path);
});

var loadPopupSuggest = function() {
    var input = $('.popup-search-input-container input').first();
    var term = input.val().trim();
    if(suggestPopupText == term) {
        return;
    }
    suggestPopupText = term;
    var container = $('.popup-search-input-container .suggest-container').first();
    container.removeClass('opened');
    if(term.length < 3) {
        return;
    }
    
    var path = input.data('pathsuggest') + '?term=' + term;
    if (typeof suggestPopupHttpClient === 'undefined') {
        suggestPopupHttpClient = new HttpClient(window.accessKey, window.contextToken);
    }
    suggestPopupHttpClient.abort();
    suggestPopupHttpClient.get(path, (response) => {
        container.html(response).addClass('opened');
    });
};

$('.popup-search-input-container input').keyup(function(e){
    if(e.keyCode == 13) {
        $('.popup-search-input-container .input-group-append').trigger("click");
        $(this).blur();
        return;
    }
    loadPopupSuggest();
});


$(document).on('paste', '.popup-search-input-container input', function() {
    loadPopupSuggest();
});

$(document).on('blur', '.popup-search-input-container input', function() {
    setTimeout(function() {
        $('.popup-search-input-container .suggest-container').first().removeClass('opened');
    }, 200);
});

$(document).on('focus', '.popup-search-input-container input', function() {
    var term = $(this).val();
    if(term.length < 3) {
        return;
    }
    if(suggestPopupText !== term) {
        return;
    }
    $('.popup-search-input-container .suggest-container').first().addClass('opened');
});

var popupNavigateRight = function(path) {
    var container = $('.topdata-finder-popup-content-right').first();
    container.find('[data-toggle="tooltip"]').tooltip('dispose');
    animateLoading(container);
    productDevicesPopupHttpClient.abort();
    productDevicesPopupHttpClient.get(path, (response, fullResponse) => {
        let contentType = fullResponse.getResponseHeader('content-type');
        let success = true;
        let returnPath = false;
        let responseHtml = '';
        let loadOffset = false;
        if(contentType === 'application/json') {
            response = JSON.parse(response);
            success = response.success;
            returnPath = response.returnPath;
            responseHtml = response.html;
            loadOffset = response.loadOffset;
        }
        else {
            returnPath = fullResponse.getResponseHeader('returnPath');
            responseHtml = response;
            loadOffset = fullResponse.getResponseHeader('loadOffset');
        }

        if(success === true) {
            if(returnPath) {
                window.popupDeviceReturnPath = returnPath;
            }
            container.html(responseHtml);
            if(loadOffset) {
                if(path.indexOf('?')>=0) {
                    popupLoadMoreDevices(path + '&offset=' + loadOffset);
                }
                else {
                    popupLoadMoreDevices(path + '?offset=' + loadOffset);
                }
            }
        };

        container.find('[data-toggle="tooltip"]').tooltip();
    });
};
    

$(document).on('click', '.topdata-finder-popup-back',function() {
    if($(this).hasClass('inactive')) {
        return;
    }
    popupHistory.pop();
    var path = popupHistory.pop();
    if(path) {
        popupNavigateRight(path);
        popupHistory.push(path);
    }
    else {
        popupResetAll();
    }
});
