---
title: Features Overview
---

This section provides a more detailed overview of the main features of the TopFinder Pro plugin.

### The Finder Bar

The finder bar is the primary tool for your customers. It consists of several components:

- **Dropdown Selects**: Customers make selections sequentially (e.g., Brand > Series > Device). The options in each dropdown are loaded dynamically via AJAX based on the previous selection. The structure of these dropdowns is controlled by the `selectboxesMode` setting.
- **A-Z Navigation**: An alphabetical list that allows customers to quickly filter brands or devices by their first letter. The behavior is controlled by the `letterDisplayDevices` setting.
- **Device History Dropdown**: If enabled (`showDeviceHistorySelect`), this dropdown shows a list of the customer's most recently viewed devices for quick selection.

### The Popup Finder

As an alternative to the static finder bar, a "Device Finder" button can be displayed in the header. Clicking this opens a large, user-friendly modal window with a more advanced interface. It includes:

- The same dropdown functionality as the main finder bar.
- A-Z navigation within the popup.
- Access to the user's "My Device List" and device history.
- A dedicated search function within the popup.
- A customizable color scheme to match your store's branding.

### Device Pages & Product Listings

The plugin automatically generates SEO-friendly pages for every brand, series, type, and device. When a customer navigates to a device page, they are presented with a complete list of all products compatible with that device.

The product listing on these pages is highly customizable:
- **Pagination**: The number of products per page can be set via `productsPerPage`.
- **Sorting**: You can define the default sort order using `defaultSortKey`.
- **Tabbed Grouping**: Using the `groupingTabPropery` setting, you can separate products into tabs based on a property like "Condition" or "Manufacturer", making it easy for customers to switch between original and compatible products.

### "My Device List" for Customers

When enabled (`showDevicelist`), logged-in customers gain access to a "My Device List" area in their account. Here, they can save their devices for future visits. This allows them to quickly find compatible products without having to use the finder every time. They can also add personalized information to their saved devices, such as a location or serial number.

### Search Integration

Device search can be integrated in two ways, controlled by the `search` setting:
1.  **Combined**: When a customer uses the main shop search bar, the results will include both regular products and matching devices in a separate, clearly marked section.
2.  **Separate**: A dedicated search bar for finding devices is added to the storefront.

### "Compatible Devices" Tab on Product Pages

To help with cross-selling and provide useful information, the plugin can add a "Compatible Devices" tab to your product detail pages. This tab lists all devices that the viewed product is compatible with. The grouping of devices in this list is controlled by the `deviceTabMode` setting.

### CMS Block

The plugin registers a "TopFinder Selectboxes" block in Shopware's Shopping Experiences (CMS). This allows you to place the finder bar on any CMS page, such as a custom landing page or the shop's homepage, giving you full control over its placement.

### Cart Integration

When the `showDeviceInCart` setting is enabled, the plugin enhances the shopping cart experience. If a customer views a device page and then adds a compatible product to their cart, a small icon and tooltip will appear next to the product in the cart, confirming which of their recently viewed devices it is for. This provides reassurance and can help reduce purchase errors.
