---
title: Funktionsübersicht
---

Dieser Abschnitt bietet einen detaillierteren Überblick über die Hauptfunktionen des TopFinder Pro Plugins.

### Die Finder-Leiste

Die Finder-Leiste ist das primäre Werkzeug für Ihre Kunden. Sie besteht aus mehreren Komponenten:

- **Dropdown-Auswahlfelder**: Kunden treffen eine sequentielle Auswahl (z.B. Marke > Serie > Gerät). Die Optionen in jedem Dropdown werden dynamisch per AJAX basierend auf der vorherigen Auswahl geladen. Die Struktur dieser Dropdowns wird durch die Einstellung `selectboxesMode` gesteuert.
- **A-Z-Navigation**: Eine alphabetische Liste, die es Kunden ermöglicht, Marken oder Geräte schnell nach ihrem Anfangsbuchstaben zu filtern. Das Verhalten wird durch die Einstellung `letterDisplayDevices` gesteuert.
- **Geräteverlauf-Dropdown**: Wenn aktiviert (`showDeviceHistorySelect`), zeigt dieses Dropdown eine Liste der zuletzt vom Kunden angesehenen Geräte zur schnellen Auswahl an.

### Der Popup-Finder

Als Alternative zur statischen Finder-Leiste kann ein "Gerätefinder"-Button im Header angezeigt werden. Ein Klick darauf öffnet ein großes, benutzerfreundliches modales Fenster mit einer erweiterten Oberfläche. Es beinhaltet:

- Die gleiche Dropdown-Funktionalität wie die Haupt-Finder-Leiste.
- A-Z-Navigation innerhalb des Popups.
- Zugriff auf die "Meine Geräteliste" und den Geräteverlauf des Benutzers.
- Eine dedizierte Suchfunktion innerhalb des Popups.
- Ein anpassbares Farbschema, das zum Branding Ihres Shops passt.

### Geräteseiten & Produktlistings

Das Plugin generiert automatisch SEO-freundliche Seiten für jede Marke, Serie, jeden Typ und jedes Gerät. Wenn ein Kunde auf eine Geräteseite navigiert, wird ihm eine vollständige Liste aller mit diesem Gerät kompatiblen Produkte angezeigt.

Das Produktlisting auf diesen Seiten ist in hohem Maße anpassbar:
- **Paginierung**: Die Anzahl der Produkte pro Seite kann über `productsPerPage` festgelegt werden.
- **Sortierung**: Sie können die standardmäßige Sortierreihenfolge mit `defaultSortKey` definieren.
- **Tab-Gruppierung**: Mit der Einstellung `groupingTabPropery` können Sie Produkte basierend auf einer Produkteigenschaft wie "Zustand" in Tabs aufteilen. Dies erleichtert es den Kunden, zwischen originalen und kompatiblen Produkten zu wechseln.

### "Meine Geräteliste" für Kunden

Wenn aktiviert (`showDevicelist`), erhalten eingeloggte Kunden Zugriff auf den Bereich "Meine Geräteliste" in ihrem Konto. Hier können sie ihre Geräte für zukünftige Besuche speichern. Dies ermöglicht es ihnen, schnell kompatible Produkte zu finden, ohne jedes Mal den Finder verwenden zu müssen. Sie können ihren gespeicherten Geräten auch personalisierte Informationen wie einen Standort oder eine Seriennummer hinzufügen.

### Suchintegration

Die Gerätesuche kann auf zwei Arten integriert werden, gesteuert durch die `search`-Einstellung:
1.  **Kombiniert**: Wenn ein Kunde die Haupt-Suchleiste des Shops verwendet, enthalten die Ergebnisse sowohl reguläre Produkte als auch passende Geräte in einem separaten, deutlich gekennzeichneten Bereich.
2.  **Separat**: Eine dedizierte Suchleiste zum Finden von Geräten wird im Storefront hinzugefügt.

### Tab "Kompatible Geräte" auf Produktdetailseiten

Um Cross-Selling zu fördern und nützliche Informationen bereitzustellen, kann das Plugin einen Tab "Kompatible Geräte" zu Ihren Produktdetailseiten hinzufügen. Dieser Tab listet alle Geräte auf, mit denen das angesehene Produkt kompatibel ist. Die Gruppierung der Geräte in dieser Liste wird durch die Einstellung `deviceTabMode` gesteuert.

### CMS-Block

Das Plugin registriert einen "TopFinder Selectboxes"-Block in den Shopware Erlebniswelten (CMS). Dies ermöglicht es Ihnen, die Finder-Leiste auf jeder beliebigen CMS-Seite zu platzieren, wie z.B. auf einer benutzerdefinierten Landingpage oder der Startseite des Shops, was Ihnen die volle Kontrolle über die Platzierung gibt.

### Warenkorb-Integration

Wenn die Einstellung `showDeviceInCart` aktiviert ist, verbessert das Plugin das Warenkorb-Erlebnis. Wenn ein Kunde eine Geräteseite ansieht und dann ein kompatibles Produkt in den Warenkorb legt, erscheint neben dem Produkt im Warenkorb ein kleines Symbol mit einem Tooltip, das bestätigt, für welches seiner kürzlich angesehenen Geräte es ist. Dies gibt Sicherheit und kann helfen, Fehlkäufe zu reduzieren.
