<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Storefront\PageLoader\Topfinder;

use Shopware\Core\Content\Category\Exception\CategoryNotFoundException;
// use Shopware\Core\Content\Product\SalesChannel\Search\ProductSearchGatewayInterface;
use Shopware\Core\Framework\DataAbstractionLayer\Exception\InconsistentCriteriaIdsException;
use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Storefront\Page\GenericPageLoader;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\HttpFoundation\Request;
use Topdata\TopdataTopFinderProSW6\Storefront\Page\Topfinder\Topfinder\TopfinderPage;
use Topdata\TopdataTopFinderProSW6\Storefront\Page\Topfinder\Topfinder\TopfinderPageLoadedEvent;

//use Shopware\Core\System\SalesChannel\SalesChannelContext;

/**
 * This class is responsible for loading the Topfinder page.
 * It uses the generic page loader to load the base page and then adds Topfinder specific data.
 */
class TopfinderPageLoader
{
    /**
     * @var GenericPageLoader
     */
    private $genericLoader;

    /**
     * @var ProductSearchGatewayInterface
     */
    //    private $searchGateway;

    /**
     * @var EventDispatcherInterface
     */
    private $eventDispatcher;

    public function __construct(
        GenericPageLoader $genericLoader,
        //        ProductSearchGatewayInterface $searchGateway,
        EventDispatcherInterface $eventDispatcher
    ) {
        $this->genericLoader = $genericLoader;
        //        $this->searchGateway = $searchGateway;
        $this->eventDispatcher = $eventDispatcher;
    }

    /**
     * Loads the Topfinder page.
     */
    public function load(Request $request, SalesChannelContext $salesChannelContext): TopfinderPage
    {
        // ---- Load the generic page
        $page = $this->genericLoader->load($request, $salesChannelContext);
        $page = TopfinderPage::createFrom($page);
dd($page);
        // ---- Dispatch the Topfinder page loaded event
        $this->eventDispatcher->dispatch(
            new TopfinderPageLoadedEvent($page, $salesChannelContext, $request)
        );

        return $page;
    }
}