<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Service;

use Doctrine\DBAL\Connection;
use Topdata\TopdataTopFinderProSW6\Util\UtilSearchTerm;

/**
 * Helper class for Topdata TopFinder Pro plugin
 *
 * This class has been refactored and its methods have been moved to more specialized services:
 * - getFilteredDevices() -> DeviceDataService
 * - getDeviceHistory() -> DeviceHistoryService_Cookie
 * - getBrands() -> BrandDataService
 * - findDevices() and countFindDevices() -> Use DeviceDataService methods instead
 *
 * @deprecated This class is kept for backward compatibility and will be removed in a future version.
 * 
 * 10/2024 renamed Helper --> HelperService
 * 04/2025 refactored: moved methods to specialized services
 */
class HelperService
{
//    public function __construct(
//        private readonly DeviceDataService $deviceDataService,
//        private readonly DeviceHistoryService_Cookie $deviceHistoryService,
//        private readonly BrandDataService $brandDataService,
//    )
//    {
//    }
//
//    /**
//     * @deprecated Use DeviceDataService::getFilteredDevices() instead
//     */
//    public function getFilteredDevices($brandId, $seriesId, $typeId, bool $codeAsKey = true): array
//    {
//        return $this->deviceDataService->getFilteredDevices($brandId, $seriesId, $typeId, $codeAsKey);
//    }
//
//    /**
//     * @deprecated Use DeviceHistoryService_Cookie::getDeviceEntities() instead
//     */
//    public function getDeviceHistory(\Symfony\Component\HttpFoundation\Request $request, \Shopware\Core\Framework\Context $context): array
//    {
//        return $this->deviceHistoryService->getDeviceEntities($request, $context);
//    }
//
//    /**
//     * @deprecated Use BrandDataService::getBrands() instead
//     */
//    public function getBrands(): array
//    {
//        return $this->brandDataService->getBrands();
//    }

    /**
     * @deprecated Use DeviceDataService::findDevices() instead
     */
    public static function findDevices(string $term, Connection $connection, int $limit = 0): array
    {
        // This static method is deprecated and should not be used.
        // Use DeviceDataService::findDevices() instead.
        trigger_error(
            'HelperService::findDevices() is deprecated. Use DeviceDataService::findDevices() instead.',
            E_USER_DEPRECATED
        );
        
        // For backward compatibility, we still provide the implementation
        $filteredTerm = UtilSearchTerm::filterTerm($term);
        if ($filteredTerm !== $term) {
            $term = $filteredTerm;
        }

        if (!$term) {
            return [];
        }

        $SQLadd = ($limit > 0) ? " LIMIT $limit" : '';

        $terms = UtilSearchTerm::getTermsFromString($term);

        $WhereAdd = '';
        if (count($terms)) {
            $WhereAdd = 'OR(';
            foreach ($terms as $key => $value) {
                $terms[$key] = '(topdata_device.keywords LIKE "%' . $value . '%")';
            }
            $WhereAdd .= implode('AND', $terms);
            $WhereAdd .= ')';
        }

        $devices = $connection->fetchAllAssociative('
SELECT topdata_device.model as name, 
       LOWER(HEX(topdata_device.id)) as id, 
       LOWER(HEX(topdata_device.brand_id)) as brand_id, 
       LOWER(HEX(topdata_device.series_id)) as series_id, 
       LOWER(HEX(topdata_device.type_id)) as type_id, 
       topdata_device.code as code, 
       topdata_brand.label as brand_name,
       topdata_brand.code as brand_code,
       topdata_series.code as series_code,
       LOWER(HEX(topdata_device.media_id)) as media_id,
       topdata_series.label as series_name,
       topdata_device_type.label as type_name
  FROM topdata_device 
  LEFT JOIN topdata_brand ON (topdata_brand.id=topdata_device.brand_id)
  LEFT JOIN topdata_series ON (topdata_series.id=topdata_device.series_id)
  LEFT JOIN topdata_device_type ON (topdata_device_type.id=topdata_device.type_id)
  WHERE (topdata_device.is_enabled=1)AND((topdata_device.keywords LIKE "%' . $term . '%")' . $WhereAdd . ')
        ORDER BY `topdata_device`.`code` ASC ' . $SQLadd);

        return count($devices) ? $devices : [];
    }

//    /**
//     * @deprecated Use DeviceDataService::countFindDevices() instead
//     */
//    public static function countFindDevices(string $term, Connection $connection): int
//    {
//        // This static method is deprecated and should not be used.
//        // Use DeviceDataService::countFindDevices() instead.
//        trigger_error(
//            'HelperService::countFindDevices() is deprecated. Use DeviceDataService::countFindDevices() instead.',
//            E_USER_DEPRECATED
//        );
//
//        // For backward compatibility, we still provide the implementation
//        $filteredTerm = UtilSearchTerm::filterTerm($term);
//        if ($filteredTerm !== $term) {
//            $term = $filteredTerm;
//        }
//
//        if (!$term) {
//            return 0;
//        }
//
//        $terms = UtilSearchTerm::getTermsFromString($term);
//
//        $WhereAdd = '';
//        if (count($terms)) {
//            $WhereAdd = 'OR(';
//            foreach ($terms as $key => $value) {
//                $terms[$key] = '(topdata_device.keywords LIKE "%' . $value . '%")';
//            }
//            $WhereAdd .= implode('AND', $terms);
//            $WhereAdd .= ')';
//        }
//
//        $devicesCount = $connection->fetchAllAssociative('
//SELECT COUNT(*) as cnt
//  FROM topdata_device
//  WHERE (topdata_device.is_enabled=1)AND((topdata_device.keywords LIKE "%' . $term . '%")' . $WhereAdd . ')
//            ');
//
//        return isset($devicesCount[0]['cnt']) ? (int)$devicesCount[0]['cnt'] : 0;
//    }
}
