<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Storefront\Page\Topfinder\Topfinder;

use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Storefront\Page\PageLoadedEvent;
use Symfony\Component\HttpFoundation\Request;

class TopfinderPageLoadedEvent extends PageLoadedEvent
{
    /**
     * @var TopfinderPage
     */
    protected $page;

    public function __construct(TopfinderPage $page, SalesChannelContext $salesChannelContext, Request $request)
    {
        $this->page = $page;
        parent::__construct($salesChannelContext, $request);
    }

    public function getPage(): TopfinderPage
    {
        return $this->page;
    }
}
