<?php declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Migration\MigrationStep;
use Topdata\TopdataTopFinderProSW6\Foundation\Util\UtilMigration;

/**
 * @internal
 */
class Migration1754558979AddFinderBarPositionDefault extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1754558979;
    }

    public function update(Connection $connection): void
    {
        UtilMigration::ensureDefaultConfig(
            $connection,
            'TopdataTopFinderProSW6', // plugin's technical name
            'finderBarPosition', // The config key from config.xml
            'belowNavigation' // The default value
        );

    }

}
