<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Storefront\Page\Device;

use Shopware\Storefront\Page\Page;
use Topdata\TopdataConnectorSW6\Core\Content\Device\DeviceEntity;
use Topdata\TopdataTopFinderProSW6\Component\BreadcrumbsTrait;

/**
 * This class holds data for the device page, accessible in the device-detail twig template.
 */
class DevicePage extends Page
{
    use BreadcrumbsTrait;

    /**
     * @var string
     */
    protected $pageTitle = '';
    public $tabs;
    public $activeTabId;
    public $listing;
    private DeviceEntity $device;
    public array $deviceHistory = []; // this is history from a cookie
    public $allProductsCount;

    public function getPageTitle(): string
    {
        return $this->pageTitle;
    }

    public function setPageTitle(string $value): void
    {
        $this->pageTitle = $value;
    }

    public function getDevice(): DeviceEntity
    {
        return $this->device;
    }

    public function setDevice(DeviceEntity $device): void
    {
        $this->device = $device;
    }

    public function getDeviceId(): string
    {
        return $this->device->getId();
    }


}
