import Plugin from 'src/plugin-system/plugin.class';
import HttpClient from 'src/service/http-client.service';
import DomAccess from 'src/helper/dom-access.helper';
import CookieStorage from 'src/helper/storage/cookie-storage.helper';
import TopdataTopFinderProDevice from "./topdata-top-finder-pro.device.class";
import PseudoModalUtil from 'src/utility/modal-extension/pseudo-modal.util';

//export default class TopdataTopFinderProDeviceList extends Plugin {

export default class TopdataTopFinderProDeviceWrapper extends Plugin {

    modal: PseudoModalUtil | null = null; // Changed from static and added type
    private _client: HttpClient; // Declare _client as a private instance property

    init() {
        this._client = new HttpClient();
        console.log('[DeviceWrapper] Initializing plugin on element:', this.el);

        this._registerEvents();
    }

    _registerEvents() {
        let elements;
        console.log('[DeviceWrapper] _registerEvents called. this.el:', this.el);

        const addDeviceButtons = this.el.querySelectorAll('.top-finder-add-device');
        console.log('[DeviceWrapper] Found "add-device" buttons:', addDeviceButtons, 'Count:', addDeviceButtons.length);

        if (addDeviceButtons.length > 0) {
            elements = addDeviceButtons; // Keep using 'elements' for consistency if preferred, or switch to addDeviceButtons
            elements.forEach((element) => {
                console.log('[DeviceWrapper] Attaching "addDevice" listener to:', element);
                element.addEventListener('click', TopdataTopFinderProDevice.addDevice.bind(this));
            });
        }

        const removeDeviceButtons = this.el.querySelectorAll('.top-finder-remove-device');
        console.log('[DeviceWrapper] Found "remove-device" buttons:', removeDeviceButtons, 'Count:', removeDeviceButtons.length);
        if (removeDeviceButtons.length > 0) {
            elements = removeDeviceButtons;
            elements.forEach((element) => {
                console.log('[DeviceWrapper] Attaching "removeDevice" listener to:', element);
                element.addEventListener('click', TopdataTopFinderProDevice.removeDevice.bind(this));
            });
        }

        const editInfoButtons = this.el.querySelectorAll('.top-finder-edit-device-info');
        console.log('[DeviceWrapper] Found "edit-device-info" buttons:', editInfoButtons, 'Count:', editInfoButtons.length);
        if (editInfoButtons.length > 0) {
            elements = editInfoButtons;
            elements.forEach((element) => {
                console.log('[DeviceWrapper] Attaching "openModal" listener to:', element);
                element.addEventListener('click', this.openModal.bind(this));
            });
        }

        const expandInfoButtons = this.el.querySelectorAll('.top-finder-expand-info');
        console.log('[DeviceWrapper] Found "expand-info" buttons:', expandInfoButtons, 'Count:', expandInfoButtons.length);
        if (expandInfoButtons.length > 0) {
            elements = expandInfoButtons;
            elements.forEach((element) => {
                console.log('[DeviceWrapper] Attaching "deviceExpandInfo" listener to:', element);
                element.addEventListener('click', this.deviceExpandInfo.bind(this));
            });
        }

    }

    openModal(event) {
        this.createAjaxModal(event.currentTarget.dataset.url)
    }


    createAjaxModal(url) {
        this._client.get(url, (responseText, request) => {
            if (request.status >= 400) {
                console.log(responseText);
            }
            try {
                this.modal = new PseudoModalUtil(
                    responseText,
                    true
                );
                this.modal.open(this.onOpenModal.bind(this));
            } catch (error) {
                console.log(error);
            }
        });
    }

    onOpenModal(event) {
        event.currentTarget.classList.add('topdata-modal');
        this._registerModalEvents(event.currentTarget);
    }

    deviceItemAdd(event){
        //event.stopPropagation();

        let container = event.currentTarget.closest('form').querySelector('.top-finder-items-container');
        let className = '.top-finder-form-device-info-empty';
        let emptyElement = event.currentTarget.closest('form').querySelector(className);
        let content = emptyElement.cloneNode(true);
        content.classList.remove(className.substring(1));
        container.appendChild(content);
        this._registerModalEvents(container);
        return false;
    }

    deviceItemDelete(event) {
        let node = event.currentTarget.closest('.top-finder-form-device-info');
        if(node) {
            let parent = node.parentNode;
            parent.removeChild(node);
        }
        return false;
    }

    deviceInfoSave(event) {
        let form = event.currentTarget.closest('form');
        let data = {
            deviceId: form.querySelector('input[name="deviceId"]').value,
            formData: {
                devices: [] as { name: string, number: string, location: string, user: string, notes: string }[] // Explicitly type the array
            }
        };

        let xdevices = form.querySelectorAll('.top-finder-items-container .form-row');
        xdevices.forEach((device) => {
            let name = device.querySelector('input[name="formData[name][]"]').value;
            let number = device.querySelector('input[name="formData[number][]"]').value;
            let location = device.querySelector('input[name="formData[location][]"]').value;
            let user = device.querySelector('input[name="formData[user][]"]').value;
            let notes = device.querySelector('input[name="formData[notes][]"]').value;

            data.formData.devices.push({
                name,
                number,
                location,
                user,
                notes
            });
        });
        this._client.post( form.action, JSON.stringify(data), (response) => {
            response = JSON.parse(response);
            //console.log(response);
            if(response['success'] === true) {
                //this.modal.close();
                const closeButton = form.closest('.modal')?.querySelector('button.close') as HTMLElement | null;
                closeButton?.click();

                const triggerButton = document.querySelector('.top-finder-search-devicelist-trigger') as HTMLElement | null;
                triggerButton?.click();
            }
            else {
                form.style.opacity = '1';
                form.style.pointerEvents = 'all';
            }
        });
        return false;
    }

    deviceExpandInfo(event) {
        let elements = event.currentTarget.closest('table').querySelectorAll('.top-finder-hiddable')
        elements.forEach((element) => {
           element.classList.toggle('top-finder-hidden');
        });
        return false;
    }


    _registerModalEvents(modal) {

        let elements;
        if (modal.querySelectorAll('.top-finder-device-list-device-item-add') !== null) {
            elements = modal.querySelectorAll('.top-finder-device-list-device-item-add');
            elements.forEach((element) => {
                element.addEventListener('click', this.deviceItemAdd.bind(this),false);
            });
        }

        if (modal.querySelectorAll('.top-finder-device-list-device-item-delete') !== null) {
            elements = modal.querySelectorAll('.top-finder-device-list-device-item-delete');
            elements.forEach((element) => {
                element.addEventListener('click', this.deviceItemDelete.bind(this),false);
            });
        }

        if (modal.querySelector('.top-finder-device-list-device-info-save') !== null) {
            let element = modal.querySelector('.top-finder-device-list-device-info-save');
            element.addEventListener('click', this.deviceInfoSave.bind(this));
        }
    }
}
