<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Controller;

use Shopware\Storefront\Controller\StorefrontController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Attribute\Route;
use Topdata\TopdataFoundationSW6\Util\UtilJsonResponse;
use Topdata\TopdataTopFinderProSW6\Service\DeviceHistoryService_Session;
use Psr\Log\LoggerInterface; // <-- Add Logger

/**
 * API Controller to expose device history stored in the session.
 * Primarily for debugging purposes.
 *
 * 04/2025 created
 */
#[Route(defaults: ['_routeScope' => ['storefront']])]
class ApiController_DeviceHistory_Session extends StorefrontController
{
    public function __construct(
        private readonly DeviceHistoryService_Session $deviceHistoryService_Session,
        private readonly LoggerInterface              $logger // <-- Inject Logger
    ) {
    }

    /**
     * Retrieves the current device history from the session service.
     */
    #[Route(
        path: '/topfinder-api/device-history-session',
        name: 'frontend.topfinder.device-history-session.get-all',
        defaults: ['XmlHttpRequest' => true],
        methods: ['GET']
    )]
    public function getCurrentHistory(): JsonResponse
    {
        $history = $this->deviceHistoryService_Session->getHistory();
        // Log what the service returned just before sending the API response
        $this->logger->info('ApiController_DeviceHistory_Session: Returning history from API: ', is_array($history) ? $history : [$history]);

        return UtilJsonResponse::payload($history);
    }
}