<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Storefront\Page\Topfinder\List;

use Shopware\Core\Framework\DataAbstractionLayer\EntityCollection;
use Shopware\Storefront\Page\Page;
use Topdata\TopdataTopFinderProSW6\Component\BreadcrumbsTrait;

class ListPage extends Page
{
    use BreadcrumbsTrait;

    public $model;
    public $popupPath    = [];
    public $devicesTotal = 0;
    public $searchTerm   = '';
    protected int $compactModeLimit = 10;
    protected $devices;
    protected array $brands;
    /**
     * @var ?EntityCollection
     */
    protected $types;
    /**
     * @var ?EntityCollection
     */
    protected $series;

    /**
     * [
     * 'brands'=>bool
     * 'types'=>bool
     * 'series'=>bool
     * 'devices'=>bool
     * ]
     * @var array
     */
    protected $show;
    protected string $title;
    protected string $pageType; // TODO: remove this


    public function getDevices()
    {
        return $this->devices;
    }

    public function setDevices($entities): void
    {
        $this->devices = $entities;
    }

    public function getBrands(): array
    {
        return $this->brands;
    }

    public function setBrands(array $entities): void
    {
        $this->brands = $entities;
    }

    public function getTypes(): EntityCollection
    {
        return $this->types;
    }

    public function setTypes(EntityCollection $entities): void
    {
        $this->types = $entities;
    }

    public function getSeries(): EntityCollection
    {
        return $this->series;
    }

    public function setSeries(EntityCollection $entities): void
    {
        $this->series = $entities;
    }

    public function getPageType(): string
    {
        return $this->pageType;
    }

    public function setPageType(string $value): void
    {
        $this->pageType = $value;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function setTitle(string $value): void
    {
        $this->title = $value;
    }

    public function getShow(): array
    {
        return $this->show;
    }

    public function setShow(array $value): void
    {
        $this->show = $value;
    }

    public function getCompactModeLimit(): int
    {
        return $this->compactModeLimit;
    }

    public function setCompactModeLimit(int $value): void
    {
        $this->compactModeLimit = $value;
    }
}
