<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Service;

use Shopware\Core\Content\Product\SalesChannel\Sorting\ProductSortingCollection;
use Shopware\Core\Framework\Context;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepository;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\EqualsFilter;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Sorting\FieldSorting;

/**
 * 11/2024 created
 */
class ProductSortingHelperService
{


    public function __construct(
        private readonly EntityRepository $productSortingRepository,
    )
    {
    }

    /**
     * 11/2024 created (sorting is still not working)
     */
    public function addSortingFromUrlKey(Criteria $criteria, string $sortKey): void
    {
        $sortingCriteria = new Criteria();
        $sortingCriteria->addFilter(new EqualsFilter('key', $sortKey));
        $sortingCriteria->addFilter(new EqualsFilter('active', true));

        $sorting = $this->productSortingRepository->search($sortingCriteria, Context::createDefaultContext())->first();

        if (!$sorting) {
            return;
        }

        $fields = $sorting->get('fields');

        foreach ($fields as $field) {
            $criteria->addSorting(
                new FieldSorting(
                    $field['field'],
                    $field['order'] === 'desc' ? FieldSorting::DESCENDING : FieldSorting::ASCENDING
                )
            );
        }
    }


    /**
     * Retrieve available product sortings.
     *
     * This method creates a criteria object to filter and sort the available product sortings.
     * It filters for active sortings related to the product entity and sorts them by priority in descending order.
     *
     * @param Context $context The context in which the search is performed
     * @return ProductSortingCollection The collection of available product sortings
     */
    public function getAvailableProductSortings(Context $context): ProductSortingCollection
    {
        $criteria = new Criteria();

        $criteria->addFilter(new EqualsFilter('active', true));
        $criteria->addSorting(new FieldSorting('priority', 'DESC'));

        return $this->productSortingRepository->search($criteria, $context)->getEntities();
    }


}
