<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6;

use Shopware\Core\Framework\Plugin;
use Shopware\Core\Framework\Plugin\Context\UninstallContext;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Topdata\TopdataFoundationSW6\DependencyInjection\TopConfigRegistryCompilerPass;

class TopdataTopFinderProSW6 extends Plugin
{
    const MAPPINGS = [];

    public function build(ContainerBuilder $container): void
    {
        parent::build($container);

        // ---- register the plugin in Topdata Configration Center's TopConfigRegistry
        if(class_exists(TopConfigRegistryCompilerPass::class)) {
            $container->addCompilerPass(new TopConfigRegistryCompilerPass(__CLASS__, self::MAPPINGS));
        }

    }

    public function uninstall(UninstallContext $context): void
    {
        parent::uninstall($context);

        if ($context->keepUserData()) {
            return;
        }
    }
}
