<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Storefront\Page\PopupDeviceWidget;

use Shopware\Storefront\Page\Page;
use Topdata\TopdataTopFinderProSW6\Component\Collection;

/**
 * Represents the page object for the popup device widget in the storefront.
 * This class extends the base Page class and includes properties specific to the popup device widget.
 * It holds data needed to render the device information popup.
 *
 * 04/2025 renamed from PopupDeviceWidget to PopupDeviceWidgetPage
 */
class PopupDeviceWidgetPage extends Page
{
    /**
     * @var mixed|null The main device data to be displayed.
     */
    public $device;

    /**
     * @var mixed|null Additional or related data for the popup.
     */
    public $other;

    /**
     * @var bool Flag indicating whether a list of devices should be shown.
     */
    public $showDevicelist = false;

    /**
     * @var string The URL associated with the device, potentially for linking.
     */
    public $deviceUrl = '';
}