import Plugin from 'src/plugin-system/plugin.class';
import DomAccess from 'src/helper/dom-access.helper';
import CookieStorage from 'src/helper/storage/cookie-storage.helper';

export default class TopdataTopFinderProDeviceSlider extends Plugin {
    static options = {
        /**
         * Selector of Item
         * @type string
         */
        itemSelector: '.top-finder-product-devices-load-tab',

        containerSelector: '.top-finder-product-devices-tab-container',
    };

    init() {
        console.log('Load TopdataTopFinderProDeviceSlider Plugin');
        this._registerEvents();
    }

    _registerEvents() {

        let selector

        selector = '.top-finder-slider-close'
        if (DomAccess.querySelector(this.el, selector) !== null)
            DomAccess.querySelector(this.el, selector).addEventListener('click', this.SliderClose.bind(this));

        selector = '.top-finder-slider-show'
        if (DomAccess.querySelector(this.el, selector) !== null)
            DomAccess.querySelector(this.el, selector).addEventListener('click', this.SliderOpen.bind(this));

    }

    SliderClose(event) {
        var elements
        console.log('SliderClose');
        elements = DomAccess.querySelectorAll(this.el, '.top-finder-slider-not-hiddable');
        if (elements !== null) {
            elements.forEach((element) => {
                element.style.display = 'block';
            });
        }
        elements = DomAccess.querySelectorAll(this.el, '.top-finder-slider-hiddable');
        if (elements !== null) {
            elements.forEach((element) => {
                element.style.display = 'none';
                //element.hide();
            });
        }
        CookieStorage.setItem('topdata-device-slider', 'hidden', 30);
    }

    SliderOpen(event) {
        var elements
        console.log('SliderOpen');
        elements = DomAccess.querySelectorAll(this.el, '.top-finder-slider-hiddable');
        if (elements !== null) {
            elements.forEach((element) => {
                element.style.display = 'block';
                //element.show();
            });
        }
        elements = DomAccess.querySelectorAll(this.el, '.top-finder-slider-not-hiddable');
        if (elements !== null) {
            elements.forEach((element) => {
                element.style.display = 'none';
                //element.hide();
            });
        }
        CookieStorage.setItem('topdata-device-slider', '');
        return false;
    }
}
