<?php

namespace Topdata\TopdataTopFinderProSW6\Util;

use Shopware\Core\Framework\Context;
use Shopware\Core\Framework\DataAbstractionLayer\EntityCollection;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepository;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\EqualsFilter;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Sorting\FieldSorting;
use Symfony\Component\HttpKernel\Exception\BadRequestHttpException;

/**
 * 10/2024 created
 */
class ControllerUtil
{
    /**
     * 10/2024 created (extracted from TopFinderController)
     */
    public static function getReturnPath($request): string
    {
        $return = $request->getPathInfo();
        if ($request->getQueryString()) {
            $return .= '?' . $request->getQueryString();
        }

        return $return;
    }


    /**
     * 11/2024 created (extracted from TopFinderController and TopFinderApiController)
     * @param string $brandCode
     * @throws BadRequestHttpException
     */
    public static function assertValidBrandcode(string $brandCode): void
    {
        if (!preg_match('/^[a-z0-9_-]+$/', $brandCode)) {
            throw new BadRequestHttpException('Invalid BrandCode');
        }
    }

    /**
     * 11/2024 created (extracted from TopFinderController)
     *
     * Retrieves an entity collection based on the provided parameters and sorting field.
     *
     * This method constructs a Criteria object with the given parameters and sorting field,
     * and then performs a search on the provided repository to return the matching entities.
     *
     * @param EntityRepository $repository The repository to search in.
     * @param array $params The parameters to filter the entities.
     * @param string|null $sortingField The field to sort the entities by. Defaults to null.
     * @param bool $deleteNullParams Whether to exclude parameters with null values. Defaults to true.
     * @return EntityCollection The collection of entities that match the criteria.
     */
    public static function getEntityCollection(
        EntityRepository $repository,
        array            $params = [],
        ?string          $sortingField = null,
        bool             $deleteNullParams = true
    ): EntityCollection
    {
        $criteria = new Criteria();
        foreach ($params as $key => $value) {
            if (($value === null) && $deleteNullParams) {
                continue;
            }
            $criteria->addFilter(new EqualsFilter($key, $value));
        }
        if ($sortingField !== null) {
            $criteria->addSorting(new FieldSorting($sortingField, FieldSorting::ASCENDING));
        }
        $criteria->setLimit(999);

        return $repository->search($criteria, Context::createDefaultContext())->getEntities();
    }


}
