import Plugin from 'src/plugin-system/plugin.class';
import DomAccess from 'src/helper/dom-access.helper';
import HttpClient from 'src/service/http-client.service';
import CookieStorage from 'src/helper/storage/cookie-storage.helper';
import TopdataTopFinderProDevice from "./topdata-top-finder-pro.device.class";
import SlimSelect from "../slimselect/slimselect.min";

export default class TopdataTopFinderProPopupFinder extends Plugin {

    static options = {
        switchSelector: 'select.top-finder-switch',
        brandSelector: 'select.top-finder-brand',
        seriesSelector: 'select.top-finder-series',
        typeSelector: 'select.top-finder-types',
        deviceSelector: 'select.top-finder-devices',
        //deviceHistorySelector: 'select.top-finder-device-history',
        deviceListDevicesSelector: 'select.top-finder-device',
        seriesContainer: '.top-finder-series-container',
        typeContainer: '.top-finder-types-container',
    };

    popupHistory = [];

    init() {
        console.log('Load TopdataTopFinderProPopupFinder Plugin');
        //this._client = new HttpClient(window.accessKey, window.contextToken);
        this._client = new HttpClient();
        this.BrandId = DomAccess.querySelector(this.el, this.options.brandSelector).value;
        this.SeriesId = DomAccess.querySelector(this.el, this.options.seriesSelector).value;
        this.TypeId = DomAccess.querySelector(this.el, this.options.typeSelector).value;
        this._registerEvents();

        let btn = document.querySelector("a[data-bs-target='#topdata-finder-popup']");

        if(btn) {
            btn.addEventListener('click', this.openModal.bind(this));
        }

        //window.addEventListener('click', this.closeModal.bind(this));
        //window.addEventListener('touchend', this.closeModal.bind(this));
    }

    /**
     * Register events
     * @private
     */
    _registerEvents() {

        if(DomAccess.querySelector(this.el, this.options.brandSelector) !== null)
            DomAccess.querySelector(this.el, this.options.brandSelector).addEventListener('change', this.onChangeBrandSelection.bind(this));

        if(DomAccess.querySelector(this.el, this.options.typeSelector) !== null)
            DomAccess.querySelector(this.el, this.options.typeSelector).addEventListener('change', this.onChangeTypeSelection.bind(this));

        if(DomAccess.querySelector(this.el, this.options.seriesSelector) !== null)
            DomAccess.querySelector(this.el, this.options.seriesSelector).addEventListener('change', this.onChangeSeriesSelection.bind(this));

        if(DomAccess.querySelector(this.el, this.options.deviceSelector) !== null)
            DomAccess.querySelector(this.el, this.options.deviceSelector).addEventListener('change', this.onChangeDeviceSelection.bind(this));


        if(DomAccess.querySelector(this.el, '.top-finder-toggle-class') !== null)
            DomAccess.querySelector(this.el, '.top-finder-toggle-class').addEventListener('click', this.onClickToggleMenu.bind(this));

        if(DomAccess.querySelector(this.el, '.topdata-finder-popup .modal-body') !== null)
            DomAccess.querySelector(this.el, '.topdata-finder-popup .modal-body').addEventListener('click', this.onClickCloseMenu.bind(this));

        if(DomAccess.querySelector(this.el, '.topdata-finder-popup-back') !== null)
            DomAccess.querySelector(this.el, '.topdata-finder-popup-back').addEventListener('click', this.onClickHistoryBack.bind(this));

        if(DomAccess.querySelector(this.el, '.topdata-finder-popup-reset') !== null)
            DomAccess.querySelector(this.el, '.topdata-finder-popup-reset').addEventListener('click', this.onClickReset.bind(this));


        // changePopupMode
        if(DomAccess.querySelector(this.el, '.topdata-finder-popup-mode-abc-trigger') !== null)
            DomAccess.querySelector(this.el, '.topdata-finder-popup-mode-abc-trigger')
                .addEventListener('click', this.changePopupMode.bind(this));

        if(DomAccess.querySelector(this.el, '.topdata-finder-popup-mode-selectboxes-trigger') !== null)
            DomAccess.querySelector(this.el, '.topdata-finder-popup-mode-selectboxes-trigger')
                .addEventListener('click', this.changePopupMode.bind(this));

        /*
        if(DomAccess.querySelector(this.el, '.topdata-finder-popup-mode-search-trigger') !== null)
            DomAccess.querySelector(this.el, '.topdata-finder-popup-mode-search-trigger')
                .addEventListener('click', this.changePopupMode.bind(this));
        */

        //if(DomAccess.querySelector(this.el, this.options.deviceHistorySelector) !== null)
        //    DomAccess.querySelector(this.el, this.options.deviceHistorySelector).addEventListener('change', this.onChangeDeviceSelection.bind(this));

        var elements;

        if(DomAccess.querySelectorAll(this.el, '.top-finder-device-popup-new') !== null) {
            elements = DomAccess.querySelectorAll(this.el, '.top-finder-device-popup-new');
            elements.forEach((element) => {
                element.addEventListener('change', this.onChangeDeviceHistory.bind(this));
            });
        }


        if(DomAccess.querySelectorAll(this.el, '.top-finder-hiddable-trigger') !== null) {
            elements = DomAccess.querySelectorAll(this.el, '.top-finder-hiddable-trigger');
            elements.forEach((element) => {
                element.addEventListener('click', this.onClickHiddableTrigger.bind(this));
            });
        }

        if(DomAccess.querySelectorAll(this.el, '.popup-navigate-right') !== null) {
            elements = DomAccess.querySelectorAll(this.el, '.popup-navigate-right');
            elements.forEach((element) => {
                element.addEventListener('click', this.onClickNavigateRight.bind(this));
            });
        }

        if(DomAccess.querySelectorAll(this.el, '.empty-content-show-link') !== null) {
            elements = DomAccess.querySelectorAll(this.el, '.empty-content-show-link');
            elements.forEach((element) => {
                element.addEventListener('click', this.onClickEmptyContentShow.bind(this));
            });
        }

        if(DomAccess.querySelectorAll(this.el, '.popup-search-input-container .input-group-append') !== null) {
            elements = DomAccess.querySelectorAll(this.el, '.popup-search-input-container .input-group-append');
            elements.forEach((element) => {
                element.addEventListener('click', this.onChangeSearchInputContainer.bind(this));
            });
        }


        if(DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-button-devicelist-add') !== null) {
            elements = DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-button-devicelist-add');
            elements.forEach((element) => {
                element.addEventListener('click', TopdataTopFinderProDevice.addDevice.bind(this));
            });
        }

        if(DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-button-devicelist-remove') !== null) {
            elements = DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-button-devicelist-remove');
            elements.forEach((element) => {
                element.addEventListener('click', TopdataTopFinderProDevice.removeDevice.bind(this));
            });
        }
    }

    openModal(event) {
        //console.log('open');
        this.popupResetAll();
    }


    onClickReset(event){
        if(!event.currentTarget.classList.contains('inactive')) {
            this.popupResetAll();
        }
    }

    popupHistoryAdd(path) {
        let lastPath = this.popupHistory.pop()
        if((path !== lastPath) && lastPath) {
            this.popupHistory.push(lastPath);
        }
        this.popupHistory.push(path);

        if(DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-back') !== null) {
            var elements = DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-back');
            elements.forEach((element) => {
                element.classList.remove('inactive');
            });
        }
    }


    onClickHiddableTrigger(event) {
        var elements
        var group = event.currentTarget.dataset.group;
        console.log(group);
        if(group) {
            elements = DomAccess.querySelectorAll(this.el, '.top-finder-hiddable[data-group="'+group+'"]');
            elements.forEach((element) => {
                element.classList.toggle('hidden');
            });
        }else{
            elements = DomAccess.querySelectorAll(this.el, '.top-finder-hiddable');
            elements.forEach((element) => {
                element.classList.toggle('hidden');
            });
        }
    }

    /**
     * @param {Event} event
     */
    onChangeBrandSelection(event) {
        event.preventDefault();

        var path
        this.BrandId = event.currentTarget.value;





        var brandSelector = DomAccess.querySelector(this.el, this.options.brandSelector);
        var seriesSelector = DomAccess.querySelector(this.el, this.options.seriesSelector);
        var typeSelector = DomAccess.querySelector(this.el, this.options.typeSelector);
        var deviceSelector = DomAccess.querySelector(this.el, this.options.deviceSelector);

        var emptySeriesLink = DomAccess.querySelector(this.el, '.empty-series-link');
        var emptyTypesLink = DomAccess.querySelector(this.el, '.empty-types-link');
        var emptyDeviceLink = DomAccess.querySelector(this.el, '.empty-devices-link');


        if(brandSelector.length !== 0) {
            path = event.currentTarget.dataset.pathgotobrand;
            path = path.replace('brandcode', this.BrandId);
            this.popupButtonDevicesEnable(path);
        }

        if(typeSelector.length !== 0) {
            path = event.currentTarget.dataset.pathloadtypes;
            this.resetSelectOptions(typeSelector);
            this.loadNewSelectOptions(path.replace('brandcode', this.BrandId), typeSelector);
            typeSelector.classList.remove('hidden');
            emptySeriesLink.classList.add('hidden');
        }

        if(seriesSelector.length !== 0) {
            path = event.currentTarget.dataset.pathloadseries;
            this.resetSelectOptions(seriesSelector);
            this.loadNewSelectOptions(path.replace('brandcode', this.BrandId), seriesSelector);
            seriesSelector.classList.remove('hidden');
            emptyTypesLink.classList.add('hidden');
        }

        if(deviceSelector.length !== 0) {
            path = event.currentTarget.dataset.pathloaddevices;
            this.resetSelectOptions(deviceSelector);
            this.loadNewSelectOptions(path.replace('brandcode', this.BrandId), deviceSelector);
            deviceSelector.classList.remove('hidden');
            emptyDeviceLink.classList.add('hidden');
        }

        DomAccess.querySelector(this.el, '.topdata-finder-popup-reset').classList.remove('inactive');
    }

    /**
     * @param {Event} event
     */
    onChangeTypeSelection(event) {
        event.preventDefault();

        var path
        this.TypeId = event.currentTarget.value;
        var deviceSelector = DomAccess.querySelector(this.el, this.options.deviceSelector);

        if(deviceSelector.length !== 0) {

            path = event.currentTarget.dataset.pathgototype;
            path = path.replace('typecode', this.TypeId);
            this.popupButtonDevicesEnable(path);

            path = event.currentTarget.dataset.pathloaddevices;
            path = path.replace('brandcode', this.BrandId);
            path = path.replace('typecode', this.TypeId);

            this.resetSelectOptions(deviceSelector);
            this.loadNewSelectOptions(path, deviceSelector);
        }
    }

    /**
     * @param {Event} event
     */
    onChangeSeriesSelection(event) {
        event.preventDefault();

        var path
        this.SeriesId = event.currentTarget.value;
        var deviceSelector = DomAccess.querySelector(this.el, this.options.deviceSelector);

        if(deviceSelector.length !== 0) {

            path = event.currentTarget.dataset.pathgotoseries;
            path = path.replace('seriescode', this.SeriesId);
            this.popupButtonDevicesEnable(path);

            path = event.currentTarget.dataset.pathloaddevices;
            path = path.replace('brandcode', this.BrandId);
            path = path.replace('seriescode', this.SeriesId);

            this.resetSelectOptions(deviceSelector);
            this.loadNewSelectOptions(path, deviceSelector);
        }
    }

    /**
     * @param {Event} event
     */
    onChangeDeviceSelection(event) {
        //event.preventDefault();
        event.stopImmediatePropagation();

        var DeviceId = event.currentTarget.value;

        if(DeviceId !== '' ){
            var path = event.currentTarget.dataset.path;
            var listType = event.currentTarget.dataset.listtype;
            var pathLisDevices = event.currentTarget.dataset.pathlisdevices;

            path += "?deviceCode=" + DeviceId + "&listType" + listType;
            this.popupLoadDevice(path, '.topdata-finder-popup-content-right');

            if(pathLisDevices){
                this.popupButtonDevicesEnable(pathLisDevices);
            }else{
                this.popupButtonDevicesDisable()
            }

            //window.location.href = path;
        }
        return false;
    }

    onChangeDeviceHistory(event) {
        event.stopImmediatePropagation();

        let DeviceCode = event.currentTarget.value;
        window.popupDeviceReturnPath = '';

        if(DeviceCode === 0 || DeviceCode === '' || DeviceCode === null || DeviceCode === event.currentTarget.dataset.plcaholder) {
            return false;
        }
        let path = event.currentTarget.dataset.path;
        let listType = event.currentTarget.dataset.listtype;
        path += "?deviceCode="+DeviceCode+"&listType="+listType;
        this.popupLoadDevice(path,'.topdata-finder-popup-content-right');
        let pathListDevice = event.currentTarget.dataset.pathlisdevices;
        if(pathListDevice) {
            this.popupButtonDevicesEnable(pathListDevice);
        }
        return false;

    }


    /*

$(document).on('change', 'select' + TOP_FINDER_SELECTOR + 'device-popup-new', function(event) {
    event.stopImmediatePropagation();
    var device_code = $(this).val();
    window.popupDeviceReturnPath = '';
    if(device_code == 0 || device_code === '' || device_code === null || device_code === $(this).data('placeholder')) {
        return false;
    }
    var path = $(this).data('path')
            + "?deviceCode="
            + device_code
            + '&listType='
            + $(this).data('listtype');

    popupLoadDevice(path, '.topdata-finder-popup-content-right');

    var pathlisdevices = $(this).data('pathlisdevices');
    if(pathlisdevices) {
        popupButtonDevicesEnable(pathlisdevices);
    }

    return false;
});
     */

    onClickNavigateRight(event) {
        event.stopPropagation();

        if(event.currentTarget.classList.contains('inactive')){
            return;
        }

        var path = event.currentTarget.dataset.path;
        if(!path) {
            return;
        }

        this.popupNavigateRight(path);
        this.popupHistoryAdd(path);

        this.popupButtonProductsDisable();
        this.popupButtonsListReset();

        this.onClickCloseMenu(event);

        DomAccess.querySelector(this.el, '.topdata-finder-popup-reset').classList.remove('inactive');
    }

    popupNavigateRight(path) {
        var container = DomAccess.querySelector(this.el, '.topdata-finder-popup-content-right');

        this._client.get(path, (responseText, request) => {
            if (request.status >= 400) {
                console.log(responseText);
            }
            try {
                let success = true;
                let response;
                let returnPath = false;
                let responseHtml = '';
                let loadOffset = false;

                if(request.getResponseHeader('content-type') === 'application/json') {
                    response = JSON.parse(responseText);
                    responseHtml = response.html;
                    success = response.success;
                } else {
                    returnPath = request.getResponseHeader('returnPath');
                    responseHtml = responseText;
                    loadOffset = request.getResponseHeader('loadOffset');
                }


                if (success === true) {
                    if(returnPath) {
                        window.popupDeviceReturnPath = returnPath;
                    }
                    container.innerHTML = responseHtml;
                    this._registrateEventsForPopupNavigateRight(container);

                    if(loadOffset) {
                        if(path.indexOf('?')>=0) {
                           this.popupLoadMoreDevices(path + '&offset=' + loadOffset);
                        }
                        else {
                          this.popupLoadMoreDevices(path + '?offset=' + loadOffset);
                        }
                    }else{
                    }
                }else {
                    console.log(responseText);
                }
            } catch (error) {
                console.log(error);
            }


            // container.find('[data-toggle="tooltip"]').tooltip();
            this.popupHistoryAdd(path);
        });

    }

    _registrateEventsForPopupNavigateRight(container) {
        let elements;

        if(container.querySelectorAll('.popup-navigate-right') !== null) {
            elements = container.querySelectorAll('.popup-navigate-right');
            elements.forEach((element) => {
                element.addEventListener('click', this.onClickNavigateRight.bind(this));
            });
        }

        if(container.querySelectorAll('.top-finder-toggle-class') !== null) {
            elements = container.querySelectorAll('.top-finder-toggle-class');
            elements.forEach((element) => {
                element.addEventListener('click', this.onClickToggleMenu.bind(this));
            });
        }

        if(container.querySelectorAll('.topdata-finder-popup-device') !== null) {
            elements = container.querySelectorAll('.topdata-finder-popup-device');
            elements.forEach((element) => {
                element.addEventListener('click', this.onClickPopupLoadDevice.bind(this));
            });
        }

        if(container.querySelectorAll('.popup-device-image') !== null) {
            elements = container.querySelectorAll('.popup-device-image');
            elements.forEach((element) => {
                element.addEventListener('mouseenter', this.onMouseEnterShowDeviceImage.bind(this));
            });
        }

        if(container.querySelector('.topfinder-popup-devicelist-mode') !== null)
            container.querySelector('.topfinder-popup-devicelist-mode')
                .addEventListener('click', this.onClickSwitchDeviceListMode.bind(this));

        if(container.querySelectorAll('.device-box .prev, .device-box .next') !== null) {
            elements = container.querySelectorAll('.device-box .prev, .device-box .next');
            elements.forEach((element) => {
                element.addEventListener('mouseenter', this.onMouseEnterDeviceBoxNext.bind(this));
                element.addEventListener('mouseleave', this.onMouseLeaveDeviceBoxNext.bind(this));
            });
        }

        if(container.querySelectorAll('.topdata-finder-popup-button-devicelist-show') !== null) {
            elements = container.querySelectorAll('.topdata-finder-popup-button-devicelist-show');
            elements.forEach((element) => {
                element.addEventListener('click', this.popupButtonDevicesListShow.bind(this));
            });
        }


        if(container.querySelectorAll('.top-finder-add-device') !== null) {
            elements = container.querySelectorAll('.top-finder-add-device');
            elements.forEach((element) => {
                element.addEventListener('click', TopdataTopFinderProDevice.addDevice.bind(this));
            });
        }

        if(container.querySelectorAll('.top-finder-remove-device') !== null) {
            elements = container.querySelectorAll('.top-finder-remove-device');
            elements.forEach((element) => {
                element.addEventListener('click', TopdataTopFinderProDevice.removeDevice.bind(this));
            });
        }

        if(container.querySelector('.topdata-finder-popup-slider-buttons-button') !== null)
            container.querySelector('.topdata-finder-popup-slider-buttons-button')
                .addEventListener('click', this.onClickSliderButton.bind(this));

        if(container.querySelector('.popup-form-apply') !== null)
            container.querySelector('.popup-form-apply')
                .addEventListener('click', this.formApply.bind(this));


    }

    onClickSwitchDeviceListMode(event) {
        var elements
        if(event.currentTarget.dataset.listmode === 'min')
        {
            event.currentTarget.dataset.listmode = 'full'
            if(DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-content-abc-devices') !== null) {
                elements = DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-content-abc-devices');
                elements.forEach((element) => {
                    element.classList.remove('mode-min');
                    element.classList.add('mode-full');
                });
            }
            CookieStorage.setItem('topfinder-popup-devicelist-mode', 'full', 30);
        }else{
            event.currentTarget.dataset.listmode = 'min'
            if(DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-content-abc-devices') !== null) {
                elements = DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-content-abc-devices');
                elements.forEach((element) => {
                    element.classList.remove('mode-full');
                    element.classList.add('mode-min');
                });
            }
            CookieStorage.setItem('topfinder-popup-devicelist-mode', 'min', 30);
        }

    }

    onClickPopupLoadDevice(event){
        var path = event.currentTarget.dataset.path;
        if(!path) {
            return;
        }
        this.popupLoadDevice(path, '.topdata-finder-popup-content-right');

    }

    popupLoadMoreDevices(path) {
        var container = DomAccess.querySelector(this.el, '.topdata-finder-popup-content-right');

        this._client.get(path, (responseText, request) => {
            if (request.status >= 400) {
                console.log(responseText);
            }
            try {
                let success = true;
                let response;
                let responseHtml = '';

                if(request.getResponseHeader('content-type') === 'application/json') {
                    response = JSON.parse(responseText);
                    responseHtml = response.html;
                    success = response.success;
                } else {
                    responseHtml = responseText;
                }

                if (success === true) {
                    var container2 = DomAccess.querySelector(container, '.topdata-finder-popup-content-abc-devices');
                    container2.append(responseHtml)
                }
            } catch (error) {
                console.log(error);
            }
        });

    }

    onClickToggleMenu(event) {
        event.stopPropagation();

        var toggleClass = event.currentTarget.dataset.class;
        var target = event.currentTarget.dataset.target;

        if(target && toggleClass && DomAccess.querySelector(this.el, target) !== null) {
            if(DomAccess.querySelector(this.el, target) !== null)
                DomAccess.querySelector(this.el, target).classList.toggle(toggleClass);
        }
    }

    onClickCloseMenu(event) {
        event.stopPropagation();

        let target = DomAccess.querySelector(this.el, '.topdata-finder-popup-menu');
        if(target !== null && target.classList.contains('opened')) {
            target.classList.remove('opened');
        }

        try {
            let elements = DomAccess.querySelectorAll(this.el, '.device-menu-content.opened');
            if(elements && elements.length > 0) {
                elements.forEach((element) => {element.classList.remove('opened');});
            }
        }catch (e) {}
    }

    onClickEmptyContentShow(event) {
        var contentBlock = event.currentTarget.dataset.content;
        if(!contentBlock) {
            return;
        }
        var container;
        var content;

        if(DomAccess.querySelector(this.el, '.topdata-finder-popup-content-right') !== null)
            container = DomAccess.querySelector(this.el, '.topdata-finder-popup-content-right');
        else {
            console.log('Object .topdata-finder-popup-content-right not found');
            return;
        }
        if(DomAccess.querySelector(this.el, contentBlock) !== null)
            content = DomAccess.querySelector(this.el, contentBlock).cloneNode(true);
        else {
            console.log('Object ' + contentBlock + ' not found');
            return;
        }
        container.replaceChildren();
        container.appendChild(content);

        if(DomAccess.querySelector(this.el, '.topdata-finder-popup-reset') !== null)
        {
            var element = DomAccess.querySelector(this.el, '.topdata-finder-popup-reset');
            element.classList.remove('inactive');
        }

        if(DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-slider-buttons-button') !== null) {
            let elements = DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-slider-buttons-button');
            elements.forEach((element) => {
                element.addEventListener('click', this.onClickSliderButton.bind(this));
            });
        }

        DomAccess.querySelector(this.el, '.topdata-finder-popup-reset').classList.remove('inactive');
    }

    resetSelectOptions(selectBox) {
        if(selectBox.length !== 0) {
            while (selectBox.options.length > 1) {
                selectBox.remove(1);
            }
        }
        return selectBox;
    }

    popupLoadDevice(url, selector) {

        var container = DomAccess.querySelector(this.el, selector);

        this._client.get(url, (responseText, request) => {
            if (request.status >= 400) {
                console.log(responseText);
            }
            try {
                const response = JSON.parse(responseText);
                if (response.success === true) {
                    this.popupHistoryAdd(url);
                    container.innerHTML =response.html;
                    this.popupButtonProductsEnable(response.deviceUrl);
                    this._registrateEventsForPopupNavigateRight(container);

                    if(response.userLogged)
                    {
                        if(response.inDeviceList) {

                            if(DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-button-devicelist-remove') !== null) {
                                let elements = DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-button-devicelist-remove');
                                elements.forEach((element) => {
                                    element.classList.add('top-finder-remove-device');
                                    element.classList.remove('hidden');
                                    element.classList.remove('inactive');
                                    element.dataset.path = response.pathListRemove;
                                });
                            }

                            if(DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-button-devicelist-add') !== null) {
                                let elements = DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-button-devicelist-add');
                                elements.forEach((element) => {
                                    element.classList.add('top-finder-add-device');
                                    element.classList.add('hidden');
                                    element.classList.add('inactive');
                                    element.dataset.path = response.pathListAdd;
                                });
                            }

                        } else {


                            if(DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-button-devicelist-remove') !== null) {
                                let elements = DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-button-devicelist-remove');
                                elements.forEach((element) => {
                                    element.classList.add('top-finder-remove-device');
                                    element.classList.add('hidden');
                                    element.classList.add('inactive');
                                    element.dataset.path = response.pathListRemove;
                                });
                            }

                            if(DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-button-devicelist-add') !== null) {
                                let elements = DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-button-devicelist-add');
                                elements.forEach((element) => {
                                    element.classList.add('top-finder-add-device');
                                    element.classList.remove('hidden');
                                    element.classList.remove('inactive');
                                    element.dataset.path = response.pathListAdd;
                                });
                            }
                        }

                    }else{
                        this.popupButtonsListReset();
                    }


                    DomAccess.querySelector(this.el, '.topdata-finder-popup-reset').classList.remove('inactive');
                    //container.find('[data-toggle="tooltip"]').tooltip();
                    if(window.popupDeviceReturnPath) {
                        let element = DomAccess.querySelector(container, '.return');
                        if(element) {
                            element.classList.remove('top-finder-hidden');
                            element.dataset.path = window.popupDeviceReturnPath;
                        }
                    }
                }else {
                    console.log(response);
                }
            } catch (error) {
                console.log(error);
            }
        });
    }

    loadNewSelectOptions(url, selectElement) {
        this._client.get(url, (responseText, request) => {
            if (request.status >= 400) {
                console.log(responseText);
            }
            try {
                const response = JSON.parse(responseText);
                if (response.found === true) {
                    Object.entries(response.items).forEach(entry => {
                        const [key, value] = entry;
                        let newOption = new Option(value,key);
                        selectElement.add(newOption,undefined);
                    });
                }else {
                    console.log(response);
                }
            } catch (error) {
                console.log(error);
            }
        });
    }


    formApply(event) {
        event.stopPropagation();

        if(event.currentTarget.classList.contains('inactive')) return;
        let formSelector = event.currentTarget.dataset.form;
        if(!formSelector) return;
        let form = DomAccess.querySelector(this.el, formSelector);
        let container = this.el.querySelector('.topdata-finder-popup-content-right');

        let data = {};
        data = this.objectifyForm(form);

        this._client.post( form.action, JSON.stringify(data), (response) => {
            response = JSON.parse(response);
            //console.log(response);
            if(response['success'] === true) {
                container.innerHTML =response.html;
                this._registrateEventsForPopupNavigateRight(container);
            } else {
                console.log(response);
            }
        });
        return false;
    }


    objectifyForm(formArray) {
        //serialize data function
        var returnArray = {};
        for (var i = 0; i < formArray.length; i++){
            returnArray[formArray[i]['name']] = formArray[i]['value'];
        }
        return returnArray;
    }

    /*

$(document).on('click', '.popup-form-apply', function() {
    if($(this).hasClass('inactive')) {
        return;
    }
    var formSelector = $(this).data('form');
    if(!formSelector) {
        return;
    }
    var form = $(formSelector).first();
    var httpClient = new HttpClient(window.accessKey, window.contextToken);

    var formUnindexed = form.serializeArray();
    var data = {};

    $.map(formUnindexed, function(n, i){
        data[n['name']] = n['value'];
    });

    var container = $('.topdata-finder-popup-content-right').first();
    animateLoading(container);
    httpClient.post( form.attr('action'), JSON.stringify(data), (response) => {
        response = JSON.parse(response);
        if(response['success'] === true) {
            container.html(response.html);
        }
        else {
            console.log(response);
        }
    });

});
     */



    popupButtonsListReset() {
        var elements;
        elements = DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-button-devicelist-remove');
        elements.forEach((element) => {
            element.classList.remove('top-finder-remove-device');
            element.classList.add('hidden');
            element.classList.add('inactive');
        });


        elements = DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-button-devicelist-add');
        elements.forEach((element) => {
            element.classList.remove('top-finder-add-device');
            element.classList.add('hidden');
            element.classList.add('inactive');
        });
    };

    popupButtonDevicesEnable(path) {
        var elements;
        elements = DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-button-devices');
        elements.forEach((element) => {
            element.dataset.path = path;
            element.classList.remove('inactive');
        });
    };

    popupButtonProductsEnable(path) {
        var elements;
        elements = DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-button-products');
        elements.forEach((element) => {
            element.href = path;
            element.classList.remove('inactive');
        });
    };

    changePopupMode(event) {

        var mode = '';
        if(event.currentTarget.classList.contains('topdata-finder-popup-mode-abc-trigger')) mode = 'abc';
        if(event.currentTarget.classList.contains('topdata-finder-popup-mode-selectboxes-trigger')) mode = 'select';
        //if(event.currentTarget.classList.contains('topdata-finder-popup-mode-search-trigger')) mode = 'search';

        this.setPopupMode(mode);
    }

    setPopupMode(mode) {

        this.popupButtonDevicesDisable();
        this.popupButtonProductsDisable();
        this.popupButtonsListReset();

        DomAccess.querySelector(this.el, '.topdata-finder-popup-reset').classList.remove('inactive');
        DomAccess.querySelector(this.el, '.topdata-finder-popup-menu .popup-menu-series-types').classList.add('inactive');

        var container;
        var content;

        container = DomAccess.querySelector(this.el, '.topdata-finder-popup-content-right');
        switch (mode) {
            case 'abc' :

                DomAccess.querySelector(this.el, '.topdata-finder-popup-mode-abc-trigger').classList.add('hidden');
                DomAccess.querySelector(this.el, '.topdata-finder-popup-mode-selectboxes-trigger').classList.remove('hidden');
                //DomAccess.querySelector(this.el, '.topdata-finder-popup-mode-search-trigger').classList.remove('hidden');

                DomAccess.querySelector(this.el, '.topdata-finder-popup-content-left.top-finder-selectboxes').classList.add('hidden');
                DomAccess.querySelector(this.el, '.topdata-finder-popup-content-left.top-finder-abc').classList.remove('hidden');
                DomAccess.querySelector(this.el, '.topdata-finder-popup-content-left.top-finder-popup-search').classList.add('hidden');

                content = DomAccess.querySelector(this.el, '.topdata-finder-popup-content-abc-empty').cloneNode(true);
                container.replaceChildren();
                container.appendChild(content);
                break;
            case 'search':

                DomAccess.querySelector(this.el, '.topdata-finder-popup-mode-abc-trigger').classList.remove('hidden');
                DomAccess.querySelector(this.el, '.topdata-finder-popup-mode-selectboxes-trigger').classList.remove('hidden');
                //DomAccess.querySelector(this.el, '.topdata-finder-popup-mode-search-trigger').classList.add('hidden');

                DomAccess.querySelector(this.el, '.topdata-finder-popup-content-left.top-finder-selectboxes').classList.add('hidden');
                DomAccess.querySelector(this.el, '.topdata-finder-popup-content-left.top-finder-abc').classList.add('hidden');
                DomAccess.querySelector(this.el, '.topdata-finder-popup-content-left.top-finder-popup-search').classList.remove('hidden');

                content = DomAccess.querySelector(this.el, '.topdata-finder-popup-content-search-empty').cloneNode(true);
                container.replaceChildren();
                container.appendChild(content);
                break;
            default:

                //selectboxes mode
                DomAccess.querySelector(this.el, '.topdata-finder-popup-menu .popup-menu-series-types').classList.remove('inactive');
                DomAccess.querySelector(this.el, '.topdata-finder-popup-mode-abc-trigger').classList.remove('hidden');
                DomAccess.querySelector(this.el, '.topdata-finder-popup-mode-selectboxes-trigger').classList.add('hidden');
                //DomAccess.querySelector(this.el, '.topdata-finder-popup-mode-search-trigger').classList.remove('hidden');

                DomAccess.querySelector(this.el, '.topdata-finder-popup-content-left.top-finder-selectboxes').classList.remove('hidden');
                DomAccess.querySelector(this.el, '.topdata-finder-popup-content-left.top-finder-abc').classList.add('hidden');
                DomAccess.querySelector(this.el, '.topdata-finder-popup-content-left.top-finder-popup-search').classList.add('hidden');

                content = DomAccess.querySelector(this.el, '.topdata-finder-popup-content-empty').cloneNode(true);
                container.replaceChildren();
                container.appendChild(content);
                break;
        }

        return 0;
    }

    popupButtonDevicesDisable() {
        var elements;
        elements = DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-button-devices');
        elements.forEach((element) => {
            element.dataset.path = ';';
            element.classList.add('inactive');
        });
    }

    popupButtonProductsDisable() {
        var elements;
        elements = DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-button-products');
        elements.forEach((element) => {
            element.href = 'javascript:;';
            element.classList.add('inactive');
        });
    }


    popupButtonDevicesListShow() {

        this.popupButtonProductsDisable();
        this.popupButtonsListReset();

        let element = DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-button-devices');
        element.classList.remove('inactive');
    }


    onClickHistoryBack(event){

        if(event.currentTarget.classList.contains('inactive')) return ;

        this.popupHistory.pop()
        var path = this.popupHistory.pop();
        if(path){
            this.popupNavigateRight(path);
            this.popupHistory.push(path);
        }else{
            this.popupResetAll();
        }
    }

    onMouseEnterShowDeviceImage(event){
       // event.stopPropagation();
        var imageBlock = event.currentTarget.cloneNode(true);
        DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-content-left').forEach((container) => {
            if(!container.classList.contains('hidden')){
                container.appendChild(imageBlock);
                setTimeout(function() {
                    imageBlock.classList.add('shown');
                }, 20);
                event.currentTarget.addEventListener('mouseleave', this.onMouseLeaveRemoveDeviceImage.bind(this));
            }
        });
    }

    onMouseLeaveRemoveDeviceImage(event){
        //event.stopPropagation();
        let elements = DomAccess.querySelectorAll(this.el, '.topdata-finder-popup-content-left .popup-device-image');

        if(elements.length> 0) {
            elements.forEach((element) => {
                var container = element.parentNode;
                container.removeChild(element);
            });
        }
    }

    onMouseEnterDeviceBoxNext(event){
        DomAccess.querySelector(this.el, '.device-box .number').classList.add('show');
    }

    onMouseLeaveDeviceBoxNext(event){
        DomAccess.querySelector(this.el, '.device-box .number').classList.remove('show');
    }

    onChangeSearchInputContainer(event){

        let input = event.currentTarget;
        let term = input.value();

        if(term.length < 3) return;

        //let container = DomAccess.querySelector(this.el, '.topdata-finder-popup-content-right');
        let path = input.dataset.path + '?term=' + term;
        //container.find('[data-toggle="tooltip"]').tooltip('dispose');
        //animateLoading(container);
        this.popupNavigateRight(path)

    }

    getSiblings(e) {
        let siblings = [];
        // if no parent, return no sibling
        if(!e.parentNode) {
            return siblings;
        }
        // first child of the parent node
        let sibling  = e.parentNode.firstChild;
        // collecting siblings
        while (sibling) {
            if (sibling.nodeType === 1 && sibling !== e) {
                siblings.push(sibling);
            }
            sibling = sibling.nextSibling;
        }
        return siblings;
    }


    onClickSliderButton(event) {

        event.currentTarget.classList.add('selected');

        let sibling;
        let siblings = this.getSiblings(event.currentTarget);

        while (sibling =siblings.shift()) {
            sibling.classList.remove('selected');
        }


        let container = DomAccess.querySelector(this.el,'.topdata-finder-popup-slider');

        if(container.querySelectorAll('.topdata-finder-popup-slide') !== null) {
            let elements = container.querySelectorAll('.topdata-finder-popup-slide');
            elements.forEach((element) => {
                element.classList.remove('selected');
            });
        }

        container.querySelector(event.currentTarget.dataset.target).classList.add('selected');

    }

    popupResetAll() {
        window.popupDeviceReturnPath = '';
        this.setPopupMode('select');

        this.popupHistory = [];

        try {
            this.el.querySelector('.topdata-finder-popup-reset').classList.add('inactive');
        } catch (e) {}
        try {
            this.el.querySelector('.topdata-finder-popup-back').classList.add('inactive');
        } catch (e) {}
        try {
            this.el.querySelector('.topdata-finder-popup-menu.popup-menu-series-types').classList.remove('inactive');
        } catch (e) {}
        try {
            this.el.querySelector('.popup-search-input-container input').value = '';
        } catch (e) {}



        let brandSelector = DomAccess.querySelector(this.el, this.options.brandSelector);
        let seriesSelector = DomAccess.querySelector(this.el, this.options.seriesSelector);
        let typeSelector = DomAccess.querySelector(this.el, this.options.typeSelector);
        let deviceSelector = DomAccess.querySelector(this.el, this.options.deviceSelector);
        //let deviceHistorySelector = DomAccess.querySelector(this.el, this.options.deviceHistorySelector);
        //var deviceListDevicesSelector = DomAccess.querySelector(this.el, this.options.deviceListDevicesSelector);


        let emptySeriesLink = DomAccess.querySelector(this.el, '.empty-series-link');
        let emptyTypesLink = DomAccess.querySelector(this.el, '.empty-types-link');
        let emptyDeviceLink = DomAccess.querySelector(this.el, '.empty-devices-link');


        if(brandSelector.length !== 0) {
            brandSelector.options.selectedIndex=0;
        }

        if(seriesSelector.length !== 0) {
            this.resetSelectOptions(seriesSelector);
            seriesSelector.classList.add('hidden');
            emptySeriesLink.classList.remove('hidden');
        }

        if(typeSelector.length !== 0) {
            this.resetSelectOptions(typeSelector);
            typeSelector.classList.add('hidden');
            emptyTypesLink.classList.remove('hidden');
        }

        if(deviceSelector.length !== 0) {
            this.resetSelectOptions(deviceSelector);
            deviceSelector.classList.add('hidden');
            emptyDeviceLink.classList.remove('hidden');
        }

        /*
        if(deviceHistorySelector.length !== 0) {
            this.resetSelectOptions(deviceHistorySelector);
        }
         */

        /*
        if(deviceListDevicesSelector.length !== 0) {
            this.resetSelectOptions(deviceListDevicesSelector);
        }
         */
    }

    /*

var popupResetAll = function() {

    brandsLoading = false;
    seriesLoading = false;
    typesLoading = false;
    devicesLoading = false;
};
     */




    /*
    $(document).on('click', '.popup-search-input-container .input-group-append', function() {
        var input = $(this).siblings('input').first();
        var term = input.val();
        if(term.length < 3) {
            return;
        }
        var container = $('.topdata-finder-popup-content-right').first();
        var path = input.data('path') + '?term=' + term;
        container.find('[data-toggle="tooltip"]').tooltip('dispose');
        animateLoading(container);
        productDevicesPopupHttpClient.abort();
        productDevicesPopupHttpClient.get(path, (response, responseFull) => {
            let returnPath = responseFull.getResponseHeader('returnPath');
            let loadOffset = responseFull.getResponseHeader('loadOffset');
            container.html(response);
            if(returnPath) {
                window.popupDeviceReturnPath = returnPath;
            }
            container.find('[data-toggle="tooltip"]').tooltip();
            if(loadOffset) {
                if(path.indexOf('?')>=0) {
                    popupLoadMoreDevices(path + '&offset=' + loadOffset);
                }
                else {
                    popupLoadMoreDevices(path + '?offset=' + loadOffset);
                }
            }
        });
        popupHistoryAdd(path);
    });
 */
}
