<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Framework\Cookie;

use Shopware\Storefront\Framework\Cookie\CookieProviderInterface;

class TopFinderCookieProvider implements CookieProviderInterface
{
    private $originalService;

    public function __construct(CookieProviderInterface $service)
    {
        $this->originalService = $service;
    }

    private const cookieGroup = [
        'isRequired'          => true,
        'snippet_name'        => 'topdata-topfinder.cookie.groupName',
        'snippet_description' => 'topdata-topfinder.cookie.groupDescription',
        'entries'             => [
            [
                'snippet_name' => 'topdata-topfinder.cookie.deviceHistoryName',
                'cookie'       => 'topdata-device-history',
                'value'        => '',
                'expiration'   => '30',
            ],
            [
                'snippet_name' => 'topdata-topfinder.cookie.deviceSelectboxesStateName',
                'cookie'       => 'topdata-device-selectboxes',
                'value'        => '',
                'expiration'   => '30',
            ],
            [
                'snippet_name' => 'topdata-topfinder.cookie.deviceSliderStateName',
                'cookie'       => 'topdata-device-slider',
                'value'        => '',
                'expiration'   => '30',
            ],
            [
                'snippet_name' => 'topdata-topfinder.cookie.deviceSwitchStateName',
                'cookie'       => 'topdata-switch',
                'value'        => '',
                'expiration'   => '30',
            ],
        ],
    ];

    public function getCookieGroups(): array
    {
        return array_merge(
            $this->originalService->getCookieGroups(),
            [
                self::cookieGroup,
            ]
        );
    }
}
