<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Storefront\Page\PopupFormWidget;

use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Storefront\Page\GenericPageLoader;
use Symfony\Component\HttpFoundation\Request;
use Topdata\TopdataTopFinderProSW6\Component\Collection;
use Topdata\TopdataTopFinderProSW6\Service\DeviceToCustomerService;
use Topdata\TopdataTopFinderProSW6\Service\HelperService;
use Topdata\TopdataTopFinderProSW6\Service\SettingsService;

class PopupFormWidgetLoader
{
    public function __construct(
        private readonly GenericPageLoader $genericPageLoader,
        private readonly SettingsService $settingsService,
        private readonly HelperService $helperService,
        private readonly DeviceToCustomerService $deviceToCustomerService,
    ) {
    }

    public function load(Request $request, SalesChannelContext $salesChannelContext): PopupFormWidget
    {
        $page = $this->genericPageLoader->load($request, $salesChannelContext);
        /** @var PopupFormWidget $page */
        $page = PopupFormWidget::createFrom($page);

        $struct = new Collection();

        $struct->set('brands', $this->helperService->getBrands());
        $struct->set('showSeries', $this->settingsService->getBool('showSeries'));
        $struct->set('showTypes', $this->settingsService->getBool('showTypes'));
        $struct->set('showDevicelist', $this->settingsService->getBool('showDevicelist'));
        if ($this->settingsService->getBool('showDevicelist')) {
            if ($salesChannelContext->getCustomer() && !($salesChannelContext->getCustomer()->getGuest())) {
                $struct->set('userLogged', true);
                $struct->set('deviceList', $this->deviceToCustomerService->getDeviceListForCustomer($salesChannelContext));
            } else {
                $struct->set('userLogged', false);
                $struct->set('deviceList', false);
            }
        }
        if ($this->settingsService->getBool('showDeviceHistory') && $this->settingsService->getBool('showDeviceHistorySelect')) {
            $struct->set(
                'deviceHistory',
                $this->helperService->getDeviceHistory(
                    $request,
                    $salesChannelContext->getContext()
                )
            );
        }

        $page->finder = $struct;

        return $page;
    }
}
