<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Storefront\Page\ListProducts;

use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Storefront\Page\PageLoadedEvent;
use Symfony\Component\HttpFoundation\Request;
use Topdata\TopdataTopFinderProSW6\Storefront\Page\ListProducts\ListProducts;

class ListProductsLoadedEvent extends PageLoadedEvent
{
    /**
     * @var ListProducts
     */
    protected $page;

    public function __construct(ListProducts $page, SalesChannelContext $salesChannelContext, Request $request)
    {
        $this->page = $page;
        parent::__construct($salesChannelContext, $request);
    }

    public function getPage(): ListProducts
    {
        return $this->page;
    }
}
