import HttpClient from 'src/service/http-client.service';
import PluginManager from 'src/plugin-system/plugin.manager';
import CookieStorage from 'src/helper/storage/cookie-storage.helper';



// ====================================================


const TOP_FINDER_SELECTOR = '.top-finder-';
const POPUP_TIMEOUT = 750;
const LOAD_PAGE_CLASS = 'top-finder-load-page-1';

var brandsLoading = 1,
    seriesLoading = 1,
    typesLoading = 1,
    devicesLoading = 1,
    popupHistory = [];
    
window.popupDeviceReturnPath = '';

var exists = function(el) {
    return (el.length !== 0);
};

var topFinderActionConfirmed = false;
var confirmFunction = function() {console.log('empty function!');};

$(document).on('click', "#top-finder-confirm-dialog-yes", function() {
    confirmFunction();
});


$(document).on('click', '[data-confirm]',function(event) {
    if(topFinderActionConfirmed) {
        return;
    }
    event.stopImmediatePropagation();
    var button = $(this);
    $("#top-finder-confirm-dialog-text").text($(this).data('confirm'));
    
    confirmFunction = function(){
        $("#top-finder-modal-confirm-dialog").find('.modal-close').first().click();
        topFinderActionConfirmed = true;
        button.trigger("click");
        if(button.attr('href') && button.attr('href') !== '#') {
            window.location.href = button.attr('href');
        }
        topFinderActionConfirmed = false;
        return false;
    };
    
    $('#top-finder-modal-confirm-dialog-popup-trigger').click();
    
    return false;
});

var deviceListHttpClient;
var popupDeviceBoxTimeout;
var popupDeviceBoxHttpClient;
var productDevicesPopupHttpClient = new HttpClient(window.accessKey, window.contextToken);
var suggestPopupHttpClient;
var suggestPopupText = '';



$(document).on('mouseenter', '[data-showdevice]', function() {
    var $self = $(this);
    var path = $self.data('path');
    popupDeviceBoxTimeout = setTimeout(function() {
        var $popup = $self.find('.top-finder-popup-devicebox');
        if (typeof popupDeviceBoxHttpClient === 'undefined') {
            popupDeviceBoxHttpClient = new HttpClient(window.accessKey, window.contextToken);
        }
        popupDeviceBoxHttpClient.abort();
                
        if(exists($popup)) {
            $popup.show();
        }
        else {
            $self.append($('<span class="top-finder-popup-devicebox"></span>'));
            popupDeviceBoxHttpClient.get(path, (response) => {
                $self.find('.top-finder-popup-devicebox').html(response).addClass('loaded');
            });
        }
    }, POPUP_TIMEOUT);
});

$(document).on('mouseleave', '[data-showdevice]', function() {
    clearTimeout(popupDeviceBoxTimeout);
    $(this).find('.top-finder-popup-devicebox').hide();
});



$(document).on('click', TOP_FINDER_SELECTOR+'product-devices-load-popup', function() {
    var path = $(this).data('path');
    var containerHeader = $('#product-devices-popup .modal-title');
    var container = $('#product-devices-popup .modal-body');
    productDevicesPopupHttpClient.abort();
    productDevicesPopupHttpClient.get(path, (response) => {
        response = JSON.parse(response);
        if(response.success === true) {
            container.html(response.html);
            containerHeader.html(response.title);
            $('#product-devices-popup-trigger').click();
        }
    });
    return false;
});



var loaded = function(data, select) {
    data = JSON.parse(data);
    var length = 0;
    $.each(data.items, function(key,value) {
        select.append($("<option></option>")
         .attr("value", key).text(value));
        length = length+1; 
    });
};

var reset = function(el) {
    if(exists(el)) {
        el.empty();
        el.append($("<option></option>")
            .data("placeholder", el.data('placeholder'))
            .attr('value', '0')
            .text(el.data('placeholder')));
        el.val(null);
    }
    return el;
};


$(document).on('click', TOP_FINDER_SELECTOR+'brand-devices-load-tab', function() {
    var className = TOP_FINDER_SELECTOR+'brand-devices-load-tab';
    $(this).removeClass(className.substr(1));
    var path = $(this).data('path');
    var tabPaneSelector = $(this).attr('href');
    var container = $(tabPaneSelector).find('.topfinder-devices-compact');
    var httpClient = new HttpClient(window.accessKey, window.contextToken);
    httpClient.get(path, (response) => {
        response = JSON.parse(response);
        if(response.success === true) {
            container.html(response.html);
            window.PluginManager.initializePlugins();
        }
    });
});

if(exists(TOP_FINDER_SELECTOR+'load-more')) {
    
    $(document).on('click', TOP_FINDER_SELECTOR+'load-more', function() {
        var path = $(this).data('path');
        var container = $(this);
        var httpClient = new HttpClient(window.accessKey, window.contextToken);
        $(this).addClass('loading');
        httpClient.get(path, (response) => {
            response = JSON.parse(response);
            if(response.success === true) {
                container.replaceWith(response.html);
                window.PluginManager.initializePlugins();
            }
        });
    });

    $(window).scroll(function() {
        let el = $(TOP_FINDER_SELECTOR+'load-more');
        if(exists(el) && (el.hasClass('loading') == false)) {
            let windowBottom = $(window).scrollTop()+$(window).height();
            let elOffset = el.offset().top;
            if(windowBottom > elOffset) {
                el.trigger('click');
            }
        }
    });
}


function makeid(length) {
    var result           = '';
    var characters       = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    var charactersLength = characters.length;
    for ( var i = 0; i < length; i++ ) {
      result += characters.charAt(Math.floor(Math.random() * 
 charactersLength));
   }
   return result;
}

// Importing SlimSelect


var script = document.createElement('script');
window.slimselects = {};
script.onload = function () {
    $.each($(TOP_FINDER_SELECTOR + 'slimselect'), function(key, el) {
        let ident = makeid(10);
        if($(el).data('slimselectid')) {
            ident = $(el).data('slimselectid');
        }
        var addToBody = $(el).hasClass('add-to-body');
        var showSearch = !addToBody;
        if (typeof window.slimselects[ident] !== 'undefined') {
            ident = ident + '2';
        }
        
        
        if($(el).hasClass('top-finder-switch')) {
            window.slimselects[ident] = new SlimSelect({
              select: el,
              addToBody: addToBody,
              showSearch: false
            });
        }
        else if($(el).hasClass('slimselect-addable')) {
            window.slimselects[ident] = new SlimSelect({
                select: el,
                addToBody: addToBody,
                showSearch: showSearch,
                addable: function (value) {
                    let val = $.trim(value);
                    if(val.length < 3) {
                        return false;
                    }
                    return {
                        text: val,
                        value: encodeURIComponent(val)
                    };
                }
            });            
        }
        else {
            window.slimselects[ident] = new SlimSelect({
                select: el,
                addToBody: addToBody,
                showSearch: showSearch
            });
        }
        window.slimselects[ident].disable();
        window.slimselects[ident].enable();
        
    });
};


$(document).ready(function() {
    brandsLoading = 0;
    seriesLoading = 0;
    typesLoading = 0;
    devicesLoading = 0;
    
    var devicesTabSelector = $('.top-finder-brand-devices-load-tab');
    if(devicesTabSelector.length) {
        devicesTabSelector.first().trigger("click");
    }
});



var offcanvasDeviceTimer;
var offcanvasDeviceTrigger = $('.top-finder-offcanvas-device-trigger');
var offvanvasDevice = $('.top-finder-offcanvas-device');

if(exists(offcanvasDeviceTrigger) && exists(offvanvasDevice)) {
    $(window).scroll(function() {
        clearTimeout(offcanvasDeviceTimer);
        offcanvasDeviceTimer = setTimeout(function() {
            var offcanvasDeviceOffset = offcanvasDeviceTrigger.offset().top - 20;
            var scrollHeigh = $(window).scrollTop();
            if(scrollHeigh > offcanvasDeviceOffset) {
                offvanvasDevice.removeClass('top-finder-hidden');
            }
            else {
                offvanvasDevice.addClass('top-finder-hidden');
            }
        }, 150);
    });
}


var animateLoading = function(container) {
    container.append( $('.topdata-finder-popup-loading-animation').first().clone() );
};



$(document).on('click', '.devicelist-subdevice-delete', function() {
    return false;
});

$(document).on('keyup change paste', '#popupEditSubdeviceForm input, #popupEditSubdeviceForm  textarea', function() {
    $(this)
        .parents('.devicelist-device-subdevice-form')
        .find('.popup-form-apply')
        .removeClass('inactive');
});

$(document).on('click', '.popup-form-apply', function() {
    if($(this).hasClass('inactive')) {
        return;
    }
    var formSelector = $(this).data('form');
    if(!formSelector) {
        return;
    }
    var form = $(formSelector).first();
    var httpClient = new HttpClient(window.accessKey, window.contextToken);
    
    var formUnindexed = form.serializeArray();
    var data = {};

    $.map(formUnindexed, function(n, i){
        data[n['name']] = n['value'];
    });
    
    var container = $('.topdata-finder-popup-content-right').first();
    animateLoading(container);
    httpClient.post( form.attr('action'), JSON.stringify(data), (response) => {
        response = JSON.parse(response);
        if(response['success'] === true) {
            container.html(response.html);
        }
        else {
            console.log(response);
        }
    });
    
});

$(document).on('click', '.topfinder-stop-propagation', function(e) {
    if($(e.target).is("a") && $(e.target).attr('href') && !($(e.target).attr('href')=='javascript:;' || $(e.target).attr('href')=='#')) {
        window.location = $(e.target).attr('href');
    }
    e.stopPropagation();
    return false;
});

