<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6;

use Shopware\Core\Framework\Plugin;
use Shopware\Core\Framework\Plugin\Context\UninstallContext;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Topdata\TopdataFoundationSW6\DependencyInjection\TopConfigServiceCompilerPass;

class TopdataTopFinderProSW6 extends Plugin
{
    const MAPPINGS = [];

    public function build(ContainerBuilder $container): void
    {
        parent::build($container);

        // ---- register the plugin in Topdata Configration Center's TopConfigService
        if(class_exists(TopConfigServiceCompilerPass::class)) {
            $container->addCompilerPass(new TopConfigServiceCompilerPass(__CLASS__, self::MAPPINGS));
        }

    }

    public function uninstall(UninstallContext $context): void
    {
        parent::uninstall($context);

        if ($context->keepUserData()) {
            return;
        }
    }
}
