<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Storefront\Page\Topfinder;

use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Storefront\Page\PageLoadedEvent;
use Symfony\Component\HttpFoundation\Request;

class DeviceListPageLoadedEvent extends PageLoadedEvent
{
    /**
     * @var DeviceListPage
     */
    protected $page;

    public function __construct(DeviceListPage $page, SalesChannelContext $salesChannelContext, Request $request)
    {
        $this->page = $page;
        parent::__construct($salesChannelContext, $request);
    }

    public function getPage(): DeviceListPage
    {
        return $this->page;
    }
}
