<?php

namespace Topdata\TopdataTopFinderProSW6\Util;

/**
 * 10/2024 created (extracted from HelperService)
 */
class UtilSearchTerm
{
    /**
     * Filter and sanitize a search term
     *
     * @param string $term The search term to filter
     * @param int $minLength Minimum allowed length for the term
     * @param int $maxLength Maximum allowed length for the term
     * @return string The filtered search term
     */
    public static function filterTerm(string $term, int $minLength = 3, int $maxLength = 25): string
    {
        $term = str_replace(['%', '\'', '"'], '', $term);
        $term = str_replace(['_', '/', '\\'], ' ', $term);
        $term = trim($term);

        $term = mb_substr($term, 0, $maxLength);

        return (mb_strlen($term) < $minLength) ? '' : $term;
    }

    /**
     * Extract search terms from a string
     *
     * @param string $string The input string
     * @param int $min Minimum length for each term
     * @param int $max Maximum length for each term
     * @param int $maxCount Maximum number of terms to extract
     * @return array An array of extracted search terms
     */
    public static function getTermsFromString(string $string, int $min = 2, int $max = 10, int $maxCount = 4): array
    {
        $rez    = [];
        $string = str_replace(['-', '/', '+', '&', '.', ','], ' ', $string);
        $words  = explode(' ', $string);
        if (count($words) > 1) {
            $firstWord = $words[0];
            unset($words[0]);
            $words = array_reverse($words);
            array_unshift($words, $firstWord);
        }

        foreach ($words as $word) {
            if (mb_strlen(trim($word)) >= $min) {
                $rez[] = mb_substr(trim($word), 0, $max);
                if (count($rez) >= $maxCount) {
                    break;
                }
            }
        }

        return $rez;
    }
}
