<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Storefront\Page\BrandLetter;

use Shopware\Storefront\Page\Page;
use Topdata\TopdataTopFinderProSW6\Component\BreadcrumbsTrait;

class BrandLetterPage extends Page
{
    use BreadcrumbsTrait;

    protected string $title = '';

    /**
     * [
     *   [
     *     'brand'=>ABC
     *     'devices'=>[
     *
     *      ]
     *     'series'=>[]
     *     'types'=>[]
     *   ],
     * ...
     * ]
     * @var array
     */
    public $devices;

    public $series;
    public $types;

    public $displayDevices;
    public $brands;
    public array $popupPath = [];

    public function getTitle(): string
    {
        return $this->title;
    }

    public function setTitle(string $value): void
    {
        $this->title = $value;
    }
}
