import Plugin from 'src/plugin-system/plugin.class';
import HttpClient from 'src/service/http-client.service';
import DomAccess from 'src/helper/dom-access.helper';
import CookieStorage from 'src/helper/storage/cookie-storage.helper';
import TopdataTopFinderProDevice from "./topdata-top-finder-pro.device.class";
import PseudoModalUtil from 'src/utility/modal-extension/pseudo-modal.util';

//export default class TopdataTopFinderProDeviceList extends Plugin {

export default class TopdataTopFinderProDeviceList extends Plugin {

    modal;
    deviceListHttpClient;

    init() {

        this._client = new HttpClient();

        this._registerEvents();
    }

    _registerEvents() {
        let element;

        element = this.el.querySelector('.top-finder-search-devicelist-trigger');
        if (element !== null) {
            element.addEventListener('click', this.searchDeviceListTrigger.bind(this));
        }


        element = this.el.querySelector('.top-finder-search-devicelist-reset');
        if (element !== null) {
            element.addEventListener('click', this.resteDeviceSearch.bind(this));
        }


        element = this.el.querySelector('.top-finder-search-devicelist-input');
        if (element !== null) {
            element.addEventListener('keydown', function(event) {
                if(event.which === 13){
                    this.el.querySelector('.top-finder-search-devicelist-trigger').click();
                }
            }.bind(this));
        }
    }


    resteDeviceSearch(event) {
        event.currentTarget.style.display ='none';
        this.el.querySelector('input.top-finder-search-devicelist-input').value = '';
        this.el.querySelector('.top-finder-search-devicelist-trigger').click();

    }

    searchDeviceListTrigger(event) {
        let keyword = this.el.querySelector('input.top-finder-search-devicelist-input').value;
        let path = event.currentTarget.dataset.path;

        if((keyword.length < 3) && (keyword.length !== 0)) {
            return false;
        }

        let container = this.el.querySelector('.top-finder-device-list-container');
        if (typeof this.deviceListHttpClient === 'undefined') {
            this.deviceListHttpClient = new HttpClient(window.accessKey);
        }
        this.deviceListHttpClient.abort();

        container.style.opacity = '0.5';
        container.style.pointerEvents = 'none';

        this.deviceListHttpClient.get(path + "?keyword=" + keyword, (response) => {
            container.innerHTML = response;
            container.style.opacity = '1';
            container.style.pointerEvents = 'all';
            if(keyword.length >2) {
                let element = this.el.querySelector('.top-finder-search-devicelist-reset');
                if(element !== null) {
                    element.style.display = 'block';
                }
                //$(TOP_FINDER_SELECTOR+'search-devicelist-reset').show();
            }
        });
    }
}
