<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Storefront\Page\Topfinder;

use Shopware\Storefront\Page\Page;
use Topdata\TopdataConnectorSW6\Core\Content\Device\DeviceCollection;
use Shopware\Core\Framework\DataAbstractionLayer\Search\EntitySearchResult;

class DeviceListPage extends Page
{
    public array $popupPath = [];
    public string $title    = '';
    public $device          = null;
    public $subdevice       = null;
    public $fallBack        = false;

    protected int $compactModeLimit = 10;
    protected array $deviceList;
    protected EntitySearchResult $devices;

    public $devicesCount = 0;

    public $properies;

    public function getDevices(): EntitySearchResult
    {
        return $this->devices;
    }

    public function setDevices(EntitySearchResult $devices): void
    {
        $this->devices = $devices;
    }

    public function setDeviceList(array $deviceList): void
    {
        $this->deviceList = $deviceList;
    }

    public function getDeviceList(): array
    {
        return $this->deviceList;
    }

    public function getCompactModeLimit(): int
    {
        return $this->compactModeLimit;
    }

    public function setCompactModeLimit(int $value): void
    {
        $this->compactModeLimit = $value;
    }
}
