<?php declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Subscriber;

use Shopware\Storefront\Pagelet\Header\HeaderPageletLoadedEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepository;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepositoryInterface;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\EqualsFilter;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\ContainsFilter;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Sorting\FieldSorting;
use Topdata\TopdataTopFinderProSW6\Component\Collection;
use Topdata\TopdataTopFinderProSW6\Component\SettingsService;
use Shopware\Storefront\Page\Suggest\SuggestPageLoadedEvent;
use Shopware\Core\Framework\Context;
use Shopware\Core\Framework\DataAbstractionLayer\Search\EntitySearchResult;
use Doctrine\DBAL\Connection;
use Shopware\Storefront\Page\Product\ProductPageLoadedEvent;
use Topdata\TopdataConnectorSW6\Component\Helper\EntitiesHelper;//del
use Shopware\Core\System\SalesChannel\Entity\SalesChannelRepository;
use Shopware\Core\System\SalesChannel\Entity\SalesChannelRepositoryInterface;
use Shopware\Core\Content\Category\CategoryEntity;
use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Topdata\TopdataTopFinderProSW6\Component\Helper;
use Shopware\Core\Framework\Adapter\Translation\Translator;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Shopware\Core\Content\Category\Service\CategoryBreadcrumbBuilder;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\AndFilter;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\OrFilter;
use Shopware\Core\System\SystemConfig\SystemConfigService;
use Topdata\TopdataProductMenu\Storefront\Page\ProductMenu\ProductMenuLoadedEvent;
use Shopware\Storefront\Event\ThemeCompilerEnrichScssVariablesEvent;

class BaseSubscriber implements EventSubscriberInterface
{
    /**
     * @var Translator
     */
    private $translator;
    
    private $deviceList = null;
    
    /**
     * @var EntityRepositoryInterface
     */
    private $brandRepository;
    
    /**
     * @var SettingsService
     */
    private $settings;
    
    /**
     * @var EntityRepositoryInterface
     */
    private $deviceRepository;
    
    /**
     * @var Connection
     */
    private $connection;
    
    /**
     * @var EntitiesHelper
     */
    private $entitiesHelper;
    
    /**
     * @var SalesChannelRepositoryInterface 
     */
    private $productRepository;
    
    /**
     * @var SalesChannelRepositoryInterface 
     */
    private $categoryRepository;
    
    /**
     * @var EntityRepositoryInterface 
     */
    private $categoryRepository2;

    /**
     * @var UrlGeneratorInterface
     */
    private $router;
    
    protected SystemConfigService $systemConfig;

    public function __construct(
        EntityRepository $brandRepository,
        SettingsService $settingsService,
        EntityRepository $deviceRepository,
        Connection $connection,
        SalesChannelRepository $productRepository,
        EntitiesHelper $entitiesHelper,
        SalesChannelRepository $categoryRepository,
        Translator $translator,
        UrlGeneratorInterface $router,
        EntityRepository $categoryRepository2,
        SystemConfigService $systemConfig
    )
    {
        $this->brandRepository = $brandRepository;
        $this->settings = $settingsService;
        $this->deviceRepository = $deviceRepository;
        $this->connection = $connection;
        $this->productRepository = $productRepository;
        $this->entitiesHelper = $entitiesHelper;
        $this->categoryRepository = $categoryRepository;
        $this->categoryRepository2 = $categoryRepository2;
        $this->translator = $translator;
        $this->router = $router;
        $this->systemConfig = $systemConfig;
    }
    
    public static function getSubscribedEvents(): array
    {
        return [
            HeaderPageletLoadedEvent::class => 'addHeaderExtensions',
            SuggestPageLoadedEvent::class => 'addDeviceSuggest',
            ProductPageLoadedEvent::class => 'addProductPageExtensions',
            ProductMenuLoadedEvent::class => 'addMenuItems',
            ThemeCompilerEnrichScssVariablesEvent::class => 'addScssVariables'
        ];
    }
    
    public function addScssVariables(ThemeCompilerEnrichScssVariablesEvent $event): void
    {
        $scssVariables = [
            "topdata-bg-dark",
            "topdata-bg-light",
            "topdata-bg-white",
            "topdata-bg-grey",
            "topdata-bg-device",
            "topdata-border-color",
            "topdata-interactive-grey",
            
            "topdata-text",
            "topdata-text-invert",
            "topdata-text-invert-inactive",
            "topdata-link-invert-hover"
        ];
        
        $map = [];
        
        foreach ($scssVariables as $item) {
            $temp = explode('-', $item);
            $camelCaseKey = 'color';
            foreach ($temp as $t) {
                if($t == 'topdata') {
                    continue;
                }
                $camelCaseKey .= ucfirst($t);
            }
            $map[$camelCaseKey] = $item;
        }
        
        
        $configPlugin = $this->systemConfig->get('TopdataTopFinderProSW6.config', $event->getSalesChannelId());
        
        foreach ($map as $configVariable => $scssVariable) {
            if(isset($configPlugin[$configVariable]) && $configPlugin[$configVariable]) {
                $event->addVariable($scssVariable, $configPlugin[$configVariable]);
            }
        }
    }
    
    public function addMenuItems(ProductMenuLoadedEvent $event) : void
    {
        $rez = $this->connection->executeQuery('
        SELECT device_id
         FROM topdata_device_to_product
         WHERE product_id = 0x' . $event->getPage()->getProductId() .'
         LIMIT 1')->fetchAllAssociative();
        
        if(!count($rez)) {
            $parentId = $this->connection->executeQuery('
                SELECT LOWER(HEX(parent_id)) as parentId FROM `product`
                 WHERE id = 0x' . $event->getPage()->getProductId() .'
                 LIMIT 1')->fetchOne();
            if($parentId) {
                $rez = $this->connection->executeQuery('
                    SELECT device_id
                     FROM topdata_device_to_product
                     WHERE product_id = 0x' . $parentId .'
                     LIMIT 1')->fetchAllAssociative();
            }
        }
        
        if(count($rez)) {
            $event->getPage()->setMenuItem(
                $this->translator->trans('topdata-topfinder.productDevices'),
                '#', 
                [
                    'path' => $this->router->generate('frontend.top_finder.compatible_devices', ['productid'=>$event->getPage()->getProductId()]),
                ], 
                ['top-finder-product-devices-load-popup']
            );
        }
        
        
        $event->getPage()->setMenuItem(
            $this->translator->trans('topdata-topfinder.showInProductList'),
            $this->router->generate('frontend.top_finder.list-products', ['ids'=>$event->getPage()->getProductId()])
        );
    }
    
    public function addProductPageExtensions(ProductPageLoadedEvent $event) : void
    {
        $this->addProductBreadcrumbs($event);
        $this->addProductDevices($event);
    }
    
    private function addProductBreadcrumbs(ProductPageLoadedEvent $event) : void
    {
        if(!$this->settings->getBool('fixProductBreadcrumbs')) {
            return;
        }
        
        $categories = $event->getPage()->getProduct()->getCategoryTree();
        
        if(!is_array($categories)) {
            return;
        }
        
        $categoryId = array_pop($categories);
        
        if(!is_string($categoryId)) {
            return;
        }
        
        /** @var CategoryEntity $category */
        $category = $this
            ->categoryRepository
            ->search(new Criteria([$categoryId]), $event->getSalesChannelContext())
            ->getEntities()
            ->first();
        
        if(!$category) {
            return;
        }
        
        $builder = new CategoryBreadcrumbBuilder($this->categoryRepository2);
        $breadcrumbs = $builder->build(
            $category, 
            $event->getSalesChannelContext()->getSalesChannel(), 
            $event->getSalesChannelContext()->getSalesChannel()->getNavigationCategoryId()
            );
        
//        $breadcrumbs = $category->buildSeoBreadcrumb(
//            $event->getSalesChannelContext()
//                ->getSalesChannel()
//                ->getNavigationCategoryId()
//            );
        if(is_array($breadcrumbs)) {
            $struct = new Collection();
            $struct->set('categories', $breadcrumbs);
            $event->getPage()->addExtension('breadcrumbs', $struct);
        }
    }
    
    private function addProductDevices(ProductPageLoadedEvent $event) : void
    {
        if($this->settings->getBool('showDevicesTab') === false) {
            return;
        }
        
        $struct = $event->getPage()->getExtension('product_devices');
        if($struct === null) {
            $struct = new Collection();
        }
        
        $insert = '';
        if($event->getPage()->getProduct()->getParentId()) {
            $insert = ', 0x'.$event->getPage()->getProduct()->getParentId();
        }
        
        $rez = $this->connection->executeQuery('
        SELECT device_id
         FROM topdata_device_to_product
         WHERE product_id IN (0x' . $event->getPage()->getProduct()->getId() .$insert.')
         LIMIT 1')->fetchAllAssociative();
        if(count($rez)) {
            $struct->set('devices', true);
            $event->getPage()->addExtension('product_devices', $struct);
            return;
        }
    }
    
    
    public function addHeaderExtensions(HeaderPageletLoadedEvent $event): void
    {
        $this->addDevicesHistory($event);
        $this->addActiveBrandsList($event);
        $this->addDevicesSlider($event);
        $this->addDeviceList($event);
        $this->addDeviceFinderPopup($event);
    }
    
    private function addDeviceFinderPopup(HeaderPageletLoadedEvent $event): void
    {
        $struct = $event->getPagelet()->getExtension('finderPopup');
        if($struct === null) {
            $struct = new Collection();
        }
        
        $struct->set('popupShowButton', $this->settings->getBool('popupShowButton'));
        $struct->set('popupSelectboxesMode', $this->settings->getString('popupSelectboxesMode'));
        
        $event->getPagelet()->addExtension('finderPopup', $struct);
    }
    
    
    private function addDevicesSlider(HeaderPageletLoadedEvent $event): void
    {
        if(!$this->settings->getBool('showDeviceHistory')) {
            return;
        }
        
        if(!$this->settings->getBool('showDevicesSlider')) {
            return;
        }
        
        $struct = $event->getPagelet()->getExtension('deviceSlider');
        if($struct === null) {
            $helper = new Helper($this->connection, $this->settings, $this->deviceRepository);
            $devicesHistory = $helper->getDeviceHistory($event->getRequest(), $event->getContext());
            $struct = new Collection();
            
            $struct->set('userHiddable', $this->settings->getBool('deviceSliderUserHide'));
            $struct->set('hidden', $event->getRequest()->cookies->get(Helper::COOKIE_DEVICE_SLIDER) === 'hidden');

            if(count($devicesHistory)) {
                $deviceListIdsArray = array_keys($helper->getDeviceListArray($event->getSalesChannelContext()));
                foreach ($devicesHistory as $device) {
                    if($this->settings->getBool('showDevicelist')) {
                        $device->setInDeviceList(
                            in_array(
                                $device->getId(), 
                                $deviceListIdsArray
                            )
                        );
                    } else {
                        $device->setInDeviceList(false);
                    }
                }
                
                $struct->set('devices', $devicesHistory);
            }
            $event->getPagelet()->addExtension('deviceSlider', $struct);
        }
    }
    
    
    private function addDevicesHistory(HeaderPageletLoadedEvent $event): void
    {
        if(!$this->settings->getBool('showDeviceHistory')) {
            return;
        }
        
        if(!$this->settings->getBool('showDeviceHistorySelect')) {
            return;
        }
        
        $struct = $event->getPagelet()->getExtension('deviceHistory');
        if($struct === null) {
            $struct = new Collection();
            $cokie = $event->getRequest()->cookies->get(Helper::COOKIE_DEVICE_HISTORY);
            $devicesHistory = [];

            if($cokie) {
                $devicesHistory = explode(',', $cokie);
            }

            if(is_array($devicesHistory) && count($devicesHistory)) {
                $criteria = (new Criteria(array_reverse($devicesHistory)))
                    ->addFilter(new EqualsFilter('enabled', true))
                    ->addAssociations(['brand']);
                $devicesHistory = $this->deviceRepository->search($criteria, $event->getContext())->getElements();
                $struct->set('devices', $devicesHistory);
            }
            
            $event->getPagelet()->addExtension('deviceHistory', $struct);
        }
    }

    
    private function addActiveBrandsList(HeaderPageletLoadedEvent $event): void
    {
        $switch = $event->getRequest()->cookies->get(Helper::COOKIE_FINDER_SWITCH);
        $struct = $event->getPagelet()->getExtension('finder');
        if($struct === null) {
            $struct = new Collection();
        }
        
        if($switch) {
            $struct->set('switch', $switch);
        }
        
        $struct->set('search', $this->settings->getString('search'));
        $topbrands = $this->connection->createQueryBuilder()
            //->select ('LOWER(HEX(id)) as id, label as name')
            ->select ('code, label as name')
            ->from('topdata_brand')
            ->where('(is_enabled = 1) AND (sort = 1)' )
            ->orderBy('label')
            ->execute()
            ->fetchAllAssociative();
        $brands = $this->connection->createQueryBuilder()
            //->select ('LOWER(HEX(id)) as id, label as name')
            ->select ('code, label as name')
            ->from('topdata_brand')
            ->where('(is_enabled = 1) AND (sort = 0)' )
            ->orderBy('label')
            ->execute()
            ->fetchAllAssociative();
        
        $struct->set('loadPage', $this->settings->getBool('loadPage'));
        $struct->set('topbrands', $topbrands);
        $struct->set('brands', $brands);
        $struct->set('showSeries', $this->settings->getConfig('showSeries'));
        $struct->set('showTypes', $this->settings->getConfig('showTypes'));
        $struct->set('showDevicelist', $this->settings->getConfig('showDevicelist'));
        $struct->set('showMode', $this->settings->getString('selectboxesMode'));
        $struct->set('selectboxesShowMode', $this->settings->getString('selectboxesShowMode'));
        $struct->set('letters', range('a', 'z'));
        $struct->set('userHiddable', $this->settings->getBool('selectboxesUserHide'));
        $struct->set('hidden', $event->getRequest()->cookies->get(Helper::COOKIE_DEVICE_SELECTBOXES) === 'hidden');
        
        $event->getPagelet()->addExtension('finder', $struct);
    }
    
    
    public function addDeviceSuggest(SuggestPageLoadedEvent $event): void
    {
        if($this->settings->getString('search') === 'combined') {
            $struct = $event->getPage()->getExtension('device_suggest');
            if($struct === null) {
                $struct = new Collection();
            }
        
            $context = $event->getContext();
            $request = $event->getRequest();

            $term = $request->query->get('search');
            $term = mb_strtolower(trim($term));
            if(mb_strlen($term)>2) {
                $devices = $this->suggestDevices($term, $context);
                $total = $this->totalSuggestDevices($term);
            } else {
                $devices = [];
                $total = 0;
            }
            $struct->set('devices', $devices);
            $struct->set('devices_total', $total);
            $event->getPage()->addExtension('device_suggest', $struct);
        }
    }

    private function totalSuggestDevices(string $term) : int
    {
        $query = "";
        $terms = $this->getTermsFromString($term);
        if(count($terms)>1) {
            $andSQL = [];
            $i = 0;
            foreach ($terms as $word) {
                $i++;
                $andSQL[] = "(keywords LIKE '%$word%')";
            }
            $andSQL = implode('AND', $andSQL);
            $query = "SELECT COUNT(*) from topdata_device WHERE (is_enabled=1) AND ((keywords LIKE '%$term%') OR ($andSQL))";
        }
        else {
            $query = "SELECT COUNT(*) from topdata_device WHERE (is_enabled=1) AND (keywords LIKE '%$term%')";
        }
        $total = $this->connection->executeQuery($query)->fetchOne();

        return (int)$total;
    }
    
    
    private function suggestDevices(string $term, Context $context) : EntitySearchResult
    {
        $criteria = new Criteria();
        $criteria->addFilter(new EqualsFilter('enabled', true));
        $criteria->addAssociations(['media','brand']);
        $criteria->addSorting(new FieldSorting('model', FieldSorting::ASCENDING));
        
        $terms = $this->getTermsFromString($term);
        if(count($terms)>1) {
            $filters = [];
            foreach ($terms as $word) {
                $filters[] = new ContainsFilter('keywords', $word);
            }
//            $criteria->addFilter(new AndFilter($filters));
            $criteria->addFilter(new OrFilter([
                new ContainsFilter('keywords', $term),
                new AndFilter($filters)
            ]));
        }
        else {
            $criteria->addFilter(new ContainsFilter('keywords', $term));
        }
        
        
        $criteria->setLimit(9);
        $devices = $this->deviceRepository->search($criteria, $context);
        return $devices;
    }
    
    private function addDeviceList(HeaderPageletLoadedEvent $event): void
    {
        $struct = new Collection();
        $helper = new Helper($this->connection, $this->settings, $this->deviceRepository);
        if($this->settings->getBool('showDevicelist')) {
            $struct->set(
                'devices',
                $helper->getDeviceListArray($event->getSalesChannelContext())
            );
            $struct->set('enabled', true);
        }
        else {
            $struct->set('enabled', false);
        }
        $event->getPagelet()->addExtension('deviceList', $struct);
    }
    
    
    private function getTermsFromString(string $string, int $min=3, int $max=10, int $maxCount=4) : array
    {
        $rez = [];
        $string = str_replace(['-', '/', '+', '&', '.', ','], ' ', $string);
        $words = explode(' ', $string);
        foreach ($words as $word) {
            if(mb_strlen(trim($word))>=$min) {
                $rez[] = mb_substr(trim($word),0,$max);
                if(count($rez)>=$maxCount) {
                    break;
                }
            }
        }
        return $rez;
    }
}