<?php declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Storefront\Page\Topfinder;

use Shopware\Core\Content\Category\Exception\CategoryNotFoundException;
use Shopware\Core\Content\Product\SalesChannel\Search\ProductSearchGatewayInterface;
use Shopware\Core\Framework\DataAbstractionLayer\Exception\InconsistentCriteriaIdsException;
use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Storefront\Page\GenericPageLoader;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\HttpFoundation\Request;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\EqualsFilter;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Sorting\FieldSorting;
use Shopware\Core\Framework\DataAbstractionLayer\Search\EntitySearchResult;
use Topdata\TopdataConnectorSW6\Core\Content\Device\DeviceCollection;
use Shopware\Core\Framework\Routing\Exception\MissingRequestParameterException;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\ContainsFilter;

class DeviceSuggestPageLoader
{
    /**
     * @var GenericPageLoader
     */
    private $genericLoader;

    /**
     * @var EventDispatcherInterface
     */
    private $eventDispatcher;
    
    private $deviceRepository;
    
    private $connection;
    
    private $total;

    public function __construct(
        GenericPageLoader $genericLoader,
        EventDispatcherInterface $eventDispatcher,
        $deviceRepository,
        $connection
    ) {
        $this->genericLoader = $genericLoader;
        $this->eventDispatcher = $eventDispatcher;
        $this->deviceRepository = $deviceRepository;
        $this->connection = $connection;
    }

    /**
     * @throws CategoryNotFoundException
     * @throws InconsistentCriteriaIdsException
     */
    public function load(Request $request, SalesChannelContext $salesChannelContext): DeviceSuggestPage
    {
        /** @var DeviceSuggestPage $page */
        $page = $this->genericLoader->load($request, $salesChannelContext);
        $page = DeviceSuggestPage::createFrom($page);
        $page->setDevices($this->searchDevices($request, $salesChannelContext));
        $page->setsearchTerm($request->query->get('term'));
        $page->setTotalSearchResult($this->total);
//        $this->eventDispatcher->dispatch(
//            new DeviceListPageLoadedEvent($page, $salesChannelContext, $request)
//        );

        return $page;
    }
    
    
    private function searchDevices($request, SalesChannelContext $context) : EntitySearchResult
    {
        $search = $request->query->get('term');

        $search = mb_strtolower(trim($search));
        if (empty($search)) {
            throw new MissingRequestParameterException('term');
        }
        
        $criteria = (new Criteria())
            ->addFilter(new EqualsFilter('enabled', true))
            ->addFilter(new ContainsFilter('keywords', $search))
            ->addAssociations(['media','brand'])
            ->addSorting(new FieldSorting('model', FieldSorting::ASCENDING));
        $criteria->setLimit(5);

        $devices = $this->deviceRepository->search($criteria, $context->getContext());

        $stmt = $this->connection->prepare("SELECT COUNT(*) from topdata_device WHERE (is_enabled=1) AND (keywords LIKE :term)");
        $stmt->bindValue('term', '%'.$search.'%');
        $stmt->execute();
        $total = $stmt->fetchColumn(0);
        $this->total = (int)$total;
        
        return $devices;
    }
}
