<?php declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Storefront\Page\PopupFormWidget;

use Shopware\Core\Content\Category\Exception\CategoryNotFoundException;
use Shopware\Core\Framework\DataAbstractionLayer\Exception\InconsistentCriteriaIdsException;
use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Storefront\Page\GenericPageLoader;
use Symfony\Component\HttpFoundation\Request;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\EqualsFilter;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Sorting\FieldSorting;
use Shopware\Core\Framework\DataAbstractionLayer\Search\EntitySearchResult;
use Shopware\Core\Framework\Routing\Exception\MissingRequestParameterException;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\ContainsFilter;
use Topdata\TopdataTopFinderProSW6\Component\SettingsService;
use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepository;
use Shopware\Core\System\SalesChannel\Entity\SalesChannelRepositoryInterface;
use Shopware\Core\Content\Product\SalesChannel\SalesChannelProductEntity;
use Topdata\TopdataTopFinderProSW6\Component\Collection;
use Topdata\TopdataTopFinderProSW6\Component\Helper;

class PopupFormWidgetLoader
{
    /**
     * @var GenericPageLoader
     */
    private $genericLoader;
    
    /**
     * @var EntityRepository
     */
    private $deviceRepository;
    
    /**
     *
     * @var Connection
     */
    private $connection;
    
    /**
     * @var SettingsService
     */
    private $settingsService;

    public function __construct(
        GenericPageLoader $genericLoader,
        EntityRepository $deviceRepository,
        Connection $connection,
        SettingsService $settingsService
    ) {
        $this->genericLoader = $genericLoader;
        $this->deviceRepository = $deviceRepository;
        $this->connection = $connection;
        $this->settingsService = $settingsService;
    }

    /**
     * @throws CategoryNotFoundException
     * @throws InconsistentCriteriaIdsException
     */
    public function load(Request $request, SalesChannelContext $salesChannelContext): PopupFormWidget
    {
        $page = $this->genericLoader->load($request, $salesChannelContext);
        /** @var PopupFormWidget $page */
        $page = PopupFormWidget::createFrom($page);
        
        $struct = new Collection();
        $helper = new Helper($this->connection, $this->settingsService, $this->deviceRepository);
        $struct->set('brands', $helper->getBrands());
        $struct->set('showSeries', $this->settingsService->getBool('showSeries'));
        $struct->set('showTypes', $this->settingsService->getBool('showTypes'));
        $struct->set('showDevicelist', $this->settingsService->getBool('showDevicelist'));
        if($this->settingsService->getBool('showDevicelist')) {
            if($salesChannelContext->getCustomer() && !($salesChannelContext->getCustomer()->getGuest())) {
                $struct->set('userLogged', true);
                $struct->set('deviceList', $helper->getDeviceList($salesChannelContext));
            }
            else {
                $struct->set('userLogged', false);
                $struct->set('deviceList', false);
            }
        }
        if($this->settingsService->getBool('showDeviceHistory') && $this->settingsService->getBool('showDeviceHistorySelect')) {
            $struct->set(
                'deviceHistory', 
                $helper->getDeviceHistory(
                    $request, 
                    $salesChannelContext->getContext()
                )
            );
        }
            
        $page->finder = $struct;
        
        return $page;
    }
}
