<?php declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Storefront\Page\PopupDeviceWidget;

use Shopware\Core\Content\Category\Exception\CategoryNotFoundException;
use Shopware\Core\Framework\DataAbstractionLayer\Exception\InconsistentCriteriaIdsException;
use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Storefront\Page\GenericPageLoader;
use Symfony\Component\HttpFoundation\Request;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\EqualsFilter;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Sorting\FieldSorting;
use Shopware\Core\Framework\DataAbstractionLayer\Search\EntitySearchResult;
use Shopware\Core\Framework\Routing\Exception\MissingRequestParameterException;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\ContainsFilter;
use Topdata\TopdataTopFinderProSW6\Component\SettingsService;
use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepository;
use Shopware\Core\System\SalesChannel\Entity\SalesChannelRepositoryInterface;
use Shopware\Core\Content\Product\SalesChannel\SalesChannelProductEntity;
use Topdata\TopdataTopFinderProSW6\Component\Collection;
use Topdata\TopdataTopFinderProSW6\Component\Helper;
use Topdata\TopdataConnectorSW6\Core\Content\Device\DeviceEntity;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Shopware\Core\Framework\Uuid\Uuid;

class PopupDeviceWidgetLoader
{
    private GenericPageLoader $genericLoader;
    private EntityRepository $deviceRepository;
    private Connection $connection;
    private SettingsService $settingsService;
    private UrlGeneratorInterface $router;
    private Helper $helper;

    public function __construct(
        GenericPageLoader $genericLoader,
        EntityRepository $deviceRepository,
        Connection $connection,
        SettingsService $settingsService,
        UrlGeneratorInterface $router,
        Helper $helper
    ) {
        $this->genericLoader = $genericLoader;
        $this->deviceRepository = $deviceRepository;
        $this->connection = $connection;
        $this->settingsService = $settingsService;
        $this->router = $router;
        $this->helper = $helper;
    }

    /**
     * @throws CategoryNotFoundException
     * @throws InconsistentCriteriaIdsException
     */
    public function load(Request $request, SalesChannelContext $salesChannelContext): PopupDeviceWidget
    {
        $page = $this->genericLoader->load($request, $salesChannelContext);
        /** @var PopupFormWidget $page */
        $page = PopupDeviceWidget::createFrom($page);
        
        
        $deviceCode = $request->get('deviceCode');
        $criteria = new Criteria();
        $criteria->addFilter(new EqualsFilter('enabled', true));
        $criteria->addFilter(new EqualsFilter('code', $deviceCode));
        $criteria->addAssociations(['media', 'brand', 'type', 'series']);
        
        /** @var DeviceEntity $device */
        $device = $this
            ->deviceRepository
            ->search($criteria, $salesChannelContext->getContext())
            ->getEntities()
            ->first();
        
        
        if($device) {
            if($salesChannelContext->getCustomer() && !($salesChannelContext->getCustomer()->getGuest())) {
                $rez = $this->connection->createQueryBuilder()
                            ->select(['device_id'])
                            ->from('topdata_device_to_customer')
                            ->where('(customer_id = 0x' 
                                . $salesChannelContext->getCustomer()->getId()
                                . ') AND (device_id = 0x'
                                . $device->getId()
                                . ')')
                            ->execute()
                            ->fetchAllAssociative();

                $device->setInDeviceList(count($rez)>0);
            }
            else {
                $device->setInDeviceList(false);
            }
            $page->showDevicelist = $this->settingsService->getBool('showDevicelist');
            
            $page->device = $device;
        }
        
        
        $page->other = [
            'deviceCode'=>$deviceCode,
            'deviceFound'=>$device?true:false
        ];
        
        return $page;
    }
    

    public function loadNew(Request $request, SalesChannelContext $salesChannelContext): PopupDeviceWidget
    {
        $page = $this->genericLoader->load($request, $salesChannelContext);
        /** @var PopupFormWidget $page */
        $page = PopupDeviceWidget::createFrom($page);
        
        
        $deviceCode = $request->get('deviceCode');
        $criteria = new Criteria();
        $criteria->addFilter(new EqualsFilter('enabled', true));
        $criteria->addFilter(new EqualsFilter('code', $deviceCode));
        $criteria->addAssociations(['media', 'brand', 'type', 'series']);
        
        /** @var DeviceEntity $device */
        $device = $this
            ->deviceRepository
            ->search($criteria, $salesChannelContext->getContext())
            ->getEntities()
            ->first();
        
        $page->other = [
            'deviceCode' => $deviceCode,
            'deviceFound' => $device ? true : false,
            'listType' => $request->get('listType', false)
        ];
        
        if($device) {
            if($salesChannelContext->getCustomer() && !($salesChannelContext->getCustomer()->getGuest())) {
                $page->other['userLogged'] = true;
                
                $page->other['pathListAdd'] = $this
                    ->router
                    ->generate('frontend.top_finder.add-device', ['deviceId'=>$device->getId()]);;
                    
                $page->other['pathListRemove'] = $this
                    ->router
                    ->generate('frontend.top_finder.remove-device', ['deviceId'=>$device->getId()]);
                
                $rez = $this->connection->createQueryBuilder()
                            ->select(['device_id'])
                            ->from('topdata_device_to_customer')
                            ->where('(customer_id = 0x' 
                                . $salesChannelContext->getCustomer()->getId()
                                . ') AND (device_id = 0x'
                                . $device->getId()
                                . ')')
                            ->execute()
                            ->fetchAllAssociative();

                $device->setInDeviceList(count($rez)>0);
            }
            else {
                $page->other['userLogged'] = false;
                $device->setInDeviceList(false);
            }
            $page->showDevicelist = $this->settingsService->getBool('showDevicelist');
            
            $page->device = $device;
            
            $this->setDevicesNavigation($page, $request, $salesChannelContext);
        }
        
        $page->deviceUrl = $this
            ->router
            ->generate('frontend.top_finder.device', ['deviceCode'=>$deviceCode]);
        
        return $page;
    }
    
    
    private function setDevicesNavigation($page, $request, $salesChannelContext) : void
    {
        $page->other['prevDevicePath'] = '';
        $page->other['prevDeviceText'] = 'topdata-topfinder.popup.devicePrev';
        $page->other['nextDevicePath'] = '';
        $page->other['nextDeviceText'] = 'topdata-topfinder.popup.deviceNext';
        $page->other['currentDeviceNumber'] = 0;
        $page->other['listDevicesCount'] = 0;
        
        if(!$page->other['listType']) {
            return;
        }
        /*
         * search
         * brand
         * brand-series
         * brand-types
         * series
         * types
         * history
         * device-list
         */
        $devices = [];
        
        $pathParams = ['listType' => $page->other['listType']];
        
        if($page->other['listType'] == 'search') {
            $pathParams['term'] = Helper::filterTerm($request->get('term'));
            $devices = Helper::findDevices($pathParams['term'], $this->connection);
        }
        elseif($page->other['listType'] == 'brand') {
            $devices = $this->connection->fetchAllAssociative(
                'SELECT LOWER(HEX(id)) as id, code'
                . ' FROM `topdata_device`'
                . ' WHERE (is_enabled=1)AND(brand_id=0x' . $page->device->getBrandId().')'
                . ' ORDER BY code ASC');
        }
        elseif($page->other['listType'] == 'series' && $page->device->getSeriesId()) {
            $devices = $this->connection->fetchAllAssociative(
                'SELECT LOWER(HEX(id)) as id, code'
                . ' FROM `topdata_device`'
                . ' WHERE (is_enabled=1)AND(series_id=0x' . $page->device->getSeriesId().')'
                . ' ORDER BY code ASC');
        }
        elseif($page->other['listType'] == 'types' && $page->device->getTypeId()) {
            $devices = $this->connection->fetchAllAssociative(
                'SELECT LOWER(HEX(id)) as id, code'
                . ' FROM `topdata_device`'
                . ' WHERE (is_enabled=1)AND(type_id=0x' . $page->device->getTypeId().')'
                . ' ORDER BY code ASC');
        }
        elseif($page->other['listType'] == 'history') {
            $cokie = $request->cookies->get(Helper::COOKIE_DEVICE_HISTORY);
            $cookieIds = [];
            $deviceIds = [];
            if($cokie) {
                $cookieIds = explode(',', $cokie);
            }

            foreach ($cookieIds as $value) {
                if(Uuid::isValid($value)) {
                    $deviceIds[] = $value;
                }
            }
            if(count($deviceIds)) {
                $unsortedDevices = $this->connection->fetchAllAssociative('
                    SELECT LOWER(HEX(id)) as id, 
                           code as code
                      FROM topdata_device 
                      WHERE (is_enabled=1)AND(topdata_device.id IN (0x'.implode(',0x', $deviceIds).'))
                ');
                $deviceIds = array_reverse($deviceIds);

                foreach ($deviceIds as $id) {
                    foreach ($unsortedDevices as $device) {
                        if($id === $device['id']) {
                            $devices[] = $device;
                        }
                    }
                }
            }
        }
        elseif($page->other['listType'] == 'device-list') {
            $devices = array_values($this->helper->getDeviceListArray($salesChannelContext));
        }
        
        
        $page->other['listDevicesCount'] = count($devices);
        
        foreach ($devices as $key => $device) {
            if($page->device->getId() == $device['id']) {
                
                $page->other['currentDeviceNumber'] = $key+1;
                
                if($key>0) {
                    $pathParams['deviceCode'] = $devices[$key-1]['code'];
                    $page->other['prevDevicePath'] = $this->router->generate(
                        'frontend.top_finder.popup_device_new', $pathParams
                    );
                }
                
                if($key < (count($devices)-1) ) {
                    $pathParams['deviceCode'] = $devices[$key+1]['code'];
                    $page->other['nextDevicePath'] = $this->router->generate(
                        'frontend.top_finder.popup_device_new', $pathParams
                    );
                }
                
                break;
            }
        }
        
    }
}
