<?php declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Storefront\Page\PopupDeviceInfoWidget;

use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Storefront\Page\GenericPageLoader;
use Symfony\Component\HttpFoundation\Request;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\EqualsFilter;
use Topdata\TopdataTopFinderProSW6\Component\SettingsService;
use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepository;
use Topdata\TopdataConnectorSW6\Core\Content\Device\Agregate\DeviceCustomer\DeviceCustomerEntity;

class PopupDeviceInfoWidgetLoader
{
    /**
     * @var GenericPageLoader
     */
    private $genericLoader;
    
    /**
     * @var EntityRepository
     */
    private $deviceCustomerRepository;
    
    /**
     * @var EntityRepository
     */
    private $deviceRepository;
    
    /**
     * @var Connection
     */
    private $connection;
    
    /**
     * @var SettingsService
     */
    private $settingsService;

    public function __construct(
        GenericPageLoader $genericLoader,
        EntityRepository $deviceCustomerRepository,
        EntityRepository $deviceRepository,
        Connection $connection,
        SettingsService $settingsService
    ) {
        $this->genericLoader = $genericLoader;
        $this->deviceCustomerRepository = $deviceCustomerRepository;
        $this->deviceRepository = $deviceRepository;
        $this->connection = $connection;
        $this->settingsService = $settingsService;
    }

    
    public function load(
        Request $request, 
        SalesChannelContext $salesChannelContext,
        string $deviceId,
        string $userId
    ): PopupDeviceInfoWidget
    {
        /** @var PopupDeviceInfoWidget $page */
        $page = PopupDeviceInfoWidget::createFrom(
            $this->genericLoader->load($request, $salesChannelContext)
        );
        
        $deviceInfoJson = $this->connection->createQueryBuilder()
            ->select ('extra_info')
            ->from('topdata_device_to_customer')
            ->where('(device_id = 0x' . $deviceId . ') AND (customer_id = 0x' . $userId . ')' )
            ->execute()
            ->fetchOne();
        $page->deviceInfo = $deviceInfoJson ? json_decode($deviceInfoJson, true) : DeviceCustomerEntity::defaultExtraInfo();
        
        
        $criteria = (new Criteria([$deviceId]))
                ->addFilter(new EqualsFilter('enabled', true))
                ->addAssociations(['media','brand','series','type']);
            
        $page->device = $this->deviceRepository->search($criteria, $salesChannelContext->getContext())->getEntities()->first();
        
        return $page;
    }
}
