<?php declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Storefront\Page\ListProducts;

use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Storefront\Page\GenericPageLoader;
use Symfony\Component\HttpFoundation\Request;
use Doctrine\DBAL\Connection;
use Topdata\TopdataTopFinderProSW6\Component\SettingsService;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Shopware\Core\Framework\Adapter\Translation\Translator;
use Topdata\TopdataTopFinderProSW6\Storefront\Page\ListProducts\ListProducts;

use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\System\SalesChannel\Entity\SalesChannelRepository;
use Shopware\Core\Content\Product\SalesChannel\ProductAvailableFilter;
use Shopware\Core\Content\Product\Aggregate\ProductVisibility\ProductVisibilityDefinition;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;

class ListProductsLoader
{
    /**
     * @var Translator
     */
    private $translator;
    
    /**
     * @var GenericPageLoader
     */
    private $genericLoader;
    
    /**
     * @var SalesChannelRepositoryInterface 
     */
    private $productRepository;
    
    /**
     * @var EventDispatcherInterface
     */
    private $eventDispatcher;

    public function __construct(
        GenericPageLoader $genericLoader,
        Translator $translator,
        SalesChannelRepository $productRepository,
        EventDispatcherInterface $eventDispatcher
    ) {
        $this->genericLoader = $genericLoader;
        $this->translator = $translator;
        $this->productRepository = $productRepository;
        $this->eventDispatcher = $eventDispatcher;
    }

    
    public function load(Request $request, SalesChannelContext $salesChannelContext, array $productIds): ListProducts
    {
        $page = $this->genericLoader->load($request, $salesChannelContext);
        /** @var ListProducts $page */
        $page = ListProducts::createFrom($page);
        $page->products = $this->loadProducts($productIds, $salesChannelContext);
        
        $page->setTitle($this->translator->trans('topdata-topfinder.listProductsTitle'));
        $page->getMetaInformation()->setMetaTitle($page->getTitle());
        
        $this->eventDispatcher->dispatch(
            new ListProductsLoadedEvent($page, $salesChannelContext, $request)
        );
        
        return $page;
    }
    
    private function loadProducts(array $productIds, SalesChannelContext $salesChannelContext)
    {
        $criteria = (new Criteria($productIds))
            ->addFilter(new ProductAvailableFilter($salesChannelContext->getSalesChannel()->getId(), ProductVisibilityDefinition::VISIBILITY_LINK))
            ->addAssociation('prices')
            ->addAssociation('cover');

        return $this->productRepository->search($criteria, $salesChannelContext)->getEntities();
    }
}