<?php declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Storefront\Page\CompatibleDevicesWidget;

use Shopware\Core\Content\Category\Exception\CategoryNotFoundException;
use Shopware\Core\Framework\DataAbstractionLayer\Exception\InconsistentCriteriaIdsException;
use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Storefront\Page\GenericPageLoader;
use Symfony\Component\HttpFoundation\Request;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\EqualsFilter;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Sorting\FieldSorting;
use Shopware\Core\Framework\DataAbstractionLayer\Search\EntitySearchResult;
use Shopware\Core\Framework\Routing\Exception\MissingRequestParameterException;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\ContainsFilter;
use Topdata\TopdataTopFinderProSW6\Component\SettingsService;
use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepository;
use Shopware\Core\System\SalesChannel\Entity\SalesChannelRepository;
use Shopware\Core\Content\Product\SalesChannel\SalesChannelProductEntity;
use Topdata\TopdataTopFinderProSW6\Component\Helper;

class CompatibleDevicesWidgetLoader
{
    /**
     * @var GenericPageLoader
     */
    private $genericLoader;
    
    /**
     * @var EntityRepository
     */
    private $deviceRepository;
    
    /**
     *
     * @var Connection
     */
    private $connection;
    
    /**
     * @var SettingsService
     */
    private $settingsService;
    
    /**
     * 
     * @var SalesChannelRepository
     */
    private $productRepository;

    public function __construct(
        GenericPageLoader $genericLoader,
        EntityRepository $deviceRepository,
        SalesChannelRepository $productRepository,
        Connection $connection,
        SettingsService $settingsService
    ) {
        $this->genericLoader = $genericLoader;
        $this->deviceRepository = $deviceRepository;
        $this->productRepository = $productRepository;
        $this->connection = $connection;
        $this->settingsService = $settingsService;
    }

    /**
     * @throws CategoryNotFoundException
     * @throws InconsistentCriteriaIdsException
     */
    public function load(Request $request, SalesChannelContext $salesChannelContext, string $productid): CompatibleDevicesWidget
    {
        $page = $this->genericLoader->load($request, $salesChannelContext);
        /** @var CompatibleDevicesWidget $page */
        $page = CompatibleDevicesWidget::createFrom($page);
        $page->product = $this->searchProduct($productid, $salesChannelContext);
        $page->setDevices($this->searchDevices($productid, $page->product->getParentId()));
        $page->groupMode = $this->settingsService->getString('deviceTabMode');
        $page->deviceNameMode = $this->settingsService->getString('deviceNameMode');
        
        $helper = new Helper($this->connection, $this->settingsService, $this->deviceRepository);
        $page->deviceList = $helper->getDeviceListArray($salesChannelContext);
        
        return $page;
    }
    
    private function searchProduct(string $productid, SalesChannelContext $salesChannelContext) : SalesChannelProductEntity
    {
        return $this
            ->productRepository
            ->search(
                (new Criteria([$productid]))->addAssociation('manufacturer'), 
                $salesChannelContext
            )
            ->getEntities()
            ->first();
    }
    
    private function searchDevices(string $productid, string $parentProductId = null) : array
    {
        $devices = $this->connection->fetchAllAssociative('
SELECT topdata_device.model as name, 
       LOWER(HEX(topdata_device.id)) as id, 
       LOWER(HEX(topdata_device.brand_id)) as brand_id, 
       LOWER(HEX(topdata_device.series_id)) as series_id, 
       LOWER(HEX(topdata_device.type_id)) as type_id, 
       topdata_device.code as code, 
       topdata_brand.label as brand_name,
       topdata_series.label as series_name,
       topdata_device_type.label as type_name
  FROM topdata_device_to_product, 
       topdata_brand,
       topdata_device
  LEFT JOIN `topdata_series` ON `topdata_device`.series_id = `topdata_series`.`id`
  LEFT JOIN topdata_device_type ON `topdata_device`.`type_id` = `topdata_device_type`.`id`
  WHERE (topdata_device.is_enabled=1)
        AND(topdata_device_to_product.product_id=0x'.$productid.')
        AND(topdata_device_to_product.device_id = topdata_device.id)
        AND(topdata_brand.id=topdata_device.brand_id)
  ORDER BY topdata_brand.label, topdata_series.label, topdata_device.model
            ');
        
        if(!count($devices) && $parentProductId) {
            $devices = $this->connection->fetchAllAssociative('
SELECT topdata_device.model as name, 
       LOWER(HEX(topdata_device.id)) as id, 
       LOWER(HEX(topdata_device.brand_id)) as brand_id, 
       LOWER(HEX(topdata_device.series_id)) as series_id, 
       LOWER(HEX(topdata_device.type_id)) as type_id, 
       topdata_device.code as code, 
       topdata_brand.label as brand_name,
       topdata_series.label as series_name,
       topdata_device_type.label as type_name
  FROM topdata_device_to_product, 
       topdata_brand,
       topdata_device
  LEFT JOIN `topdata_series` ON `topdata_device`.series_id = `topdata_series`.`id`
  LEFT JOIN topdata_device_type ON `topdata_device`.`type_id` = `topdata_device_type`.`id`
  WHERE (topdata_device.is_enabled=1)
        AND(topdata_device_to_product.product_id=0x'.$parentProductId.')
        AND(topdata_device_to_product.device_id = topdata_device.id)
        AND(topdata_brand.id=topdata_device.brand_id)
  ORDER BY topdata_brand.label, topdata_series.label, topdata_device.model
            ');
        }
        
        return $devices;
    }
}
