<?php declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Storefront\Page\CompatibleDevicesWidget;

use Shopware\Storefront\Page\Page;
use Shopware\Core\Framework\DataAbstractionLayer\Search\EntitySearchResult;

class CompatibleDevicesWidget extends Page
{
    /**
     * @var array
     */
    protected $devices = [];
    
    public $brandName;
    public $groupMode;
    public $deviceNameMode;
    public $uniqueSeries = [];
    public $uniqueTypes = [];
    public $noTypeDevicesCount = 0;
    public $deviceList = [];
    
    public function getDevices() : array
    {
        return $this->devices;
    }
    
    public function setDevices(array $devices): void
    {
        $this->devices = $devices;
        foreach ($devices as $device) {
            if($device['series_id'] && !isset($this->uniqueSeries[$device['series_id']])) {
                $this->uniqueSeries[$device['series_id']] = $device['series_name'];
            }
            if($device['type_id'] && !isset($this->uniqueTypes[$device['type_id']])) {
                $this->uniqueTypes[$device['type_id']] = $device['type_name'];
            }
            elseif(!$device['type_id']) {
                $this->noTypeDevicesCount++;
            }
            $this->uniqueTypes = array_unique($this->uniqueTypes);
            sort($this->uniqueTypes, SORT_LOCALE_STRING);
        }
    }
}
