import Plugin from 'src/plugin-system/plugin.class';
import DomAccess from 'src/helper/dom-access.helper';
import HttpClient from 'src/service/http-client.service';
import CookieStorage from 'src/helper/storage/cookie-storage.helper';
import PseudoModalUtil from 'src/utility/modal-extension/pseudo-modal.util';
//import SlimSelect from "../slimselect/slimselect.min";

export default class TopdataTopFinderProFinder extends Plugin {

    static options = {

        switchSelector: 'select.top-finder-switch',
        brandSelector: 'select.top-finder-brand',
        seriesSelector: 'select.top-finder-series',
        typeSelector: 'select.top-finder-types',
        deviceSelector: 'select.top-finder-devices',
        deviceHistorySelector: 'select.top-finder-device-history',

        seriesContainer: '.top-finder-series-container',
        typeContainer: '.top-finder-types-container',
    };

    init() {

        console.log('Load TopdataTopFinderProFinder Plugin');
        //this._client = new HttpClient(window.accessKey, window.contextToken);
        this._client = new HttpClient();


        this.BrandId = DomAccess.querySelector(this.el, this.options.brandSelector).value;
        this.SeriesId = DomAccess.querySelector(this.el, this.options.seriesSelector).value;
        this.TypeId = DomAccess.querySelector(this.el, this.options.typeSelector).value;

        /*
        this.brandSlimSelect = new SlimSelect({'select': this.options.brandSelector});
        this.seriesSlimSelect = new SlimSelect({'select': this.options.seriesSelector});
        new SlimSelect({'select': this.options.typeSelector});
        this.deviceSlimSelect = new SlimSelect({'select': this.options.deviceSelector});
        new SlimSelect({'select': this.options.deviceHistorySelector});
         */

        this._registerEvents();
    }

    /**
     * Register events
     * @private
     */
    _registerEvents() {


        if(DomAccess.querySelector(this.el, this.options.switchSelector) !== null)
            DomAccess.querySelector(this.el, this.options.switchSelector).addEventListener('change', this.onChangeSwitchSelection.bind(this));

        if(DomAccess.querySelector(this.el, this.options.brandSelector) !== null)
            DomAccess.querySelector(this.el, this.options.brandSelector).addEventListener('change', this.onChangeBrandSelection.bind(this));

        if(DomAccess.querySelector(this.el, this.options.typeSelector) !== null)
            DomAccess.querySelector(this.el, this.options.typeSelector).addEventListener('change', this.onChangeTypeSelection.bind(this));

        if(DomAccess.querySelector(this.el, this.options.seriesSelector) !== null)
            DomAccess.querySelector(this.el, this.options.seriesSelector).addEventListener('change', this.onChangeSeriesSelection.bind(this));

        if(DomAccess.querySelector(this.el, this.options.deviceSelector) !== null)
            DomAccess.querySelector(this.el, this.options.deviceSelector).addEventListener('change', this.onChangeDeviceSelection.bind(this));

        if(DomAccess.querySelector(this.el, this.options.deviceHistorySelector) !== null)
            DomAccess.querySelector(this.el, this.options.deviceHistorySelector).addEventListener('change', this.onChangeDeviceSelection.bind(this));


        if(DomAccess.querySelector(this.el, this.options.deviceHistorySelector) !== null)
            DomAccess.querySelector(this.el, this.options.deviceHistorySelector).addEventListener('change', this.onChangeDeviceSelection.bind(this));

        let element

        element = DomAccess.querySelector(this.el, '.top-finder-selectboxes-close.top-finder-selectboxes-hide')
        if(element) element.addEventListener('click', this.closeSelectbox.bind(this));

        element = DomAccess.querySelector(this.el, '.top-finder-selectboxes-close.top-finder-selectboxes-show')
        if(element) element.addEventListener('click', this.openSelectbox.bind(this));
    }

    closeSelectbox(event){

        let element = DomAccess.querySelector(this.el, '.top-finder-selectboxes')
        element.classList.add('top-finder-selectboxes-hidden')

        CookieStorage.setItem('topdata-device-selectboxes', 'hidden', 30);
        return false;
    }

    openSelectbox(event){
        let element = DomAccess.querySelector(this.el, '.top-finder-selectboxes')
        element.classList.remove('top-finder-selectboxes-hidden')

        CookieStorage.setItem('topdata-device-selectboxes', '', 30);
        return false;
    }


    /**
     * @param {Event} event
     */
    onChangeSwitchSelection(event) {
        event.preventDefault();

        console.log(event.currentTarget.value);

        CookieStorage.setItem('topdata-switch', event.currentTarget.value, 30);

        if(event.currentTarget.value === 'types') {
            DomAccess.querySelector(this.el, this.options.seriesContainer).style.display = 'none';
            DomAccess.querySelector(this.el, this.options.typeContainer).style.display = 'block';
        }else{
            DomAccess.querySelector(this.el, this.options.typeContainer).style.display = 'none';
            DomAccess.querySelector(this.el, this.options.seriesContainer).style.display = 'block';
        }
    }


    openModal(content) {
        // create a new modal instance
        this.modal = new PseudoModalUtil(content);

        // open the modal window and make it visible
        this.modal.open();
    }

    /**
     * @param {Event} event
     */
    onChangeBrandSelection(event) {
        event.preventDefault();

        var path
        this.BrandId = event.currentTarget.value;

        var seriesSelector = DomAccess.querySelector(this.el, this.options.seriesSelector);
        var typeSelector = DomAccess.querySelector(this.el, this.options.typeSelector);
        var deviceSelector = DomAccess.querySelector(this.el, this.options.deviceSelector);

        if(typeSelector.length !== 0) {
            path = event.currentTarget.dataset.pathloadtypes;
            this.resetSelectOptions(typeSelector);
            this.loadNewSelectOptions(path.replace('brandcode', this.BrandId), typeSelector);
        }

        if(seriesSelector.length !== 0) {
            path = event.currentTarget.dataset.pathloadseries;
            this.resetSelectOptions(seriesSelector);
            this.loadNewSelectOptions(path.replace('brandcode', this.BrandId), seriesSelector);
        }

        if(deviceSelector.length !== 0) {
            path = event.currentTarget.dataset.pathloaddevices;
            this.resetSelectOptions(deviceSelector);
            this.loadNewSelectOptions(path.replace('brandcode', this.BrandId), deviceSelector);
        }
    }

    /**
     * @param {Event} event
     */
    onChangeTypeSelection(event) {
        event.preventDefault();

        var path
        this.TypeId = event.currentTarget.value;
        var deviceSelector = DomAccess.querySelector(this.el, this.options.deviceSelector);

        if(deviceSelector.length !== 0) {
            path = event.currentTarget.dataset.pathloaddevices;
            path = path.replace('brandcode', this.BrandId);
            path = path.replace('typecode', this.TypeId);

            this.resetSelectOptions(deviceSelector);
            this.loadNewSelectOptions(path, deviceSelector);
        }
    }

    /**
     * @param {Event} event
     */
    onChangeSeriesSelection(event) {
        event.preventDefault();

        var path
        this.SeriesId = event.currentTarget.value;
        var deviceSelector = DomAccess.querySelector(this.el, this.options.deviceSelector);

        if(deviceSelector.length !== 0) {
            path = event.currentTarget.dataset.pathloaddevices;
            path = path.replace('brandcode', this.BrandId);
            path = path.replace('seriescode', this.SeriesId);

            this.resetSelectOptions(deviceSelector);
            this.loadNewSelectOptions(path, deviceSelector);
        }
    }


    /**
     * @param {Event} event
     */
    onChangeDeviceSelection(event) {
        event.preventDefault();

        var path
        var DeviceId = event.currentTarget.value;

        if(DeviceId !== '' ){
            path = event.currentTarget.dataset.pathgotodevice;
            path = path.replace('devicecode', DeviceId);
            window.location.href = path;
        }
        return false;
    }



    resetSelectOptions(selectBox) {
        if(selectBox.length !== 0) {
            while (selectBox.options.length > 1) {
                selectBox.remove(1);
            }
        }
        return selectBox;
    }

    loadNewSelectOptions(url, selectElement) {
        this._client.get(url, (responseText, request) => {
            if (request.status >= 400) {
                console.log(responseText);
            }
            try {
                const response = JSON.parse(responseText);
                if (response.found === true) {
                    Object.entries(response.items).forEach(entry => {
                        const [key, value] = entry;
                        let newOption = new Option(value,key);
                        selectElement.add(newOption,undefined);
                    });
                }else {
                    console.log(response);
                }
            } catch (error) {
                console.log(error);
            }
        });
    }

}
