<?php declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Component;

use Shopware\Core\System\SystemConfig\SystemConfigService;

class SettingsService
{
    /**
     * @var array
     */
    private $config;

    public function __construct(SystemConfigService $systemConfigService)
    {
        $this->config = $systemConfigService->get('TopdataTopFinderProSW6.config');
        $this->setConfig();
    }
    
    public function setConfig($salesChanngelId = false)
    {
        if($salesChanngelId) {
            $this->config = $systemConfigService->get('TopdataTopFinderProSW6.config', $salesChanngelId);
        }
        
        if(isset($this->config['selectboxesMode'])) {
            if($this->config['selectboxesMode'] == 'series') {
                $this->config['showSeries'] = true;
                $this->config['showTypes'] = false;
            }
            elseif($this->config['selectboxesMode'] == 'types') {
                $this->config['showSeries'] = false;
                $this->config['showTypes'] = true;
            }
            elseif($this->config['selectboxesMode'] == 'both') {
                $this->config['showSeries'] = true;
                $this->config['showTypes'] = true;
            }
            else {
                $this->config['showSeries'] = false;
                $this->config['showTypes'] = false;
            }
        }
    }
    
    public function getConfig(string $key) : bool
    {
        return $this->getBool($key);
    }
    
    public function getBool(string $key) : bool
    {
        return isset($this->config[$key]) ? (bool)$this->config[$key] : false;
    }
    
    public function getString(string $key) : string
    {
        return isset($this->config[$key]) ? (string)$this->config[$key] : '';
    }
    
    public function getInt(string $key, bool $notNegative = false) : int
    {
        $ret = isset($this->config[$key]) ? (int)$this->config[$key] : 0;
        
        if($notNegative && ($ret<0)) {
            $ret = 0;
        }
        
        return $ret;
    }
}