<?php

declare(strict_types=1);

namespace Topdata\TopdataTopFinderProSW6\Storefront\PageLoader\Topfinder;

use Shopware\Core\Content\Category\Exception\CategoryNotFoundException;
use Shopware\Core\Content\Product\SalesChannel\Search\ProductSearchGatewayInterface;
use Shopware\Core\Framework\DataAbstractionLayer\Exception\InconsistentCriteriaIdsException;
use Shopware\Storefront\Page\GenericPageLoader;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\HttpFoundation\Request;
use Topdata\TopdataTopFinderProSW6\Storefront\Page\Topfinder\SalesChannelContext;
use Topdata\TopdataTopFinderProSW6\Storefront\Page\Topfinder\Topfinder\TopfinderPage;
use Topdata\TopdataTopFinderProSW6\Storefront\Page\Topfinder\Topfinder\TopfinderPageLoadedEvent;

//use Shopware\Core\System\SalesChannel\SalesChannelContext;

class TopfinderPageLoader
{
    /**
     * @var GenericPageLoader
     */
    private $genericLoader;

    /**
     * @var ProductSearchGatewayInterface
     */
    //    private $searchGateway;

    /**
     * @var EventDispatcherInterface
     */
    private $eventDispatcher;

    public function __construct(
        GenericPageLoader $genericLoader,
        //        ProductSearchGatewayInterface $searchGateway,
        EventDispatcherInterface $eventDispatcher
    ) {
        $this->genericLoader = $genericLoader;
        //        $this->searchGateway = $searchGateway;
        $this->eventDispatcher = $eventDispatcher;
    }

    /**
     * @throws CategoryNotFoundException
     * @throws InconsistentCriteriaIdsException
     */
    public function load(Request $request, SalesChannelContext $salesChannelContext): TopfinderPage
    {
        $page = $this->genericLoader->load($request, $salesChannelContext);
        $page = TopfinderPage::createFrom($page);

        //        if (!$request->query->has('search')) {
        //            throw new \Symfony\Component\HttpKernel\Exception\BadRequestHttpException('search');
        //        }

        //        $result = $this->searchGateway->search($request, $salesChannelContext);
        //
        //        $page->setListing($result);
        //        $page->setSearchResult(StorefrontSearchResult::createFrom($result));

        //        $page->setSearchTerm(
        //            (string) $request->query->get('search')
        //        );

        $this->eventDispatcher->dispatch(
            new TopfinderPageLoadedEvent($page, $salesChannelContext, $request)
        );

        return $page;
    }
}
