import Plugin from 'src/plugin-system/plugin.class';
import DomAccess from 'src/helper/dom-access.helper';
import HttpClient from 'src/service/http-client.service';

export default class TopdataTopFinderProProductDetailDeviceTab extends Plugin {
    static options = {
        /**
         * Selector of Item
         * @type string
         */
        itemSelector: '.top-finder-product-devices-load-tab',

        containerSelector: '.top-finder-product-devices-tab-container',
    };

    init() {
        this._client = new HttpClient();
        var TopFeedProductDetailTabElement = DomAccess.querySelector(document, this.options.itemSelector);
        TopFeedProductDetailTabElement.addEventListener('click', this.loadDeviceData.bind(this));
    }

    /**
     * @param {Event} event
     */
    loadDeviceData(event) {
        event.preventDefault();
        var path = DomAccess.querySelector(document, this.options.itemSelector).dataset.path;
        var container = DomAccess.querySelector(document, this.options.containerSelector);

        this._client.get(path, (responseText, request) => {
            if (request.status >= 400) {
                console.log(responseText);
            }
            try {
                const response = JSON.parse(responseText);
                if (response.success === true) {
                    container.innerHTML = response.html;
                }else {
                    console.log(response);
                }
            } catch (error) {
                console.log(error);
            }
        });
    }
}
