import Plugin from 'src/plugin-system/plugin.class';
import HttpClient from 'src/service/http-client.service';
import DomAccess from 'src/helper/dom-access.helper';
import CookieStorage from 'src/helper/storage/cookie-storage.helper';

//export default class TopdataTopFinderProDeviceList extends Plugin {

export default class TopdataTopFinderProDevice extends Plugin {
    static options = {
        /**
         * Selector of Item
         * @type string
         */
        itemSelector: '.top-finder-product-devices-load-tab',

        containerSelector: '.top-finder-product-devices-tab-container',
    };

    static addDevice(event){
        event.stopPropagation();

        if(event.currentTarget.dataset.loading === 'true'){
            return false;
        }
        let client = new HttpClient();
        let path = event.currentTarget.dataset.path;
        event.currentTarget.dataset.loading = 'true';

        console.log('[TopFinderPro] addDevice: path', path);
        console.log('[TopFinderPro] addDevice: window.csrf', window.csrf);

        client.get(path, (responseText, request) => {
            if (request.status >= 400) {
                console.error('[TopFinderPro] addDevice error:', responseText);
            }
            TopdataTopFinderProDevice.deviceAdded(responseText);
        });
        event.currentTarget.dataset.loading = 'false';
    }

    static removeDevice(event){
        event.stopPropagation();

        if(event.currentTarget.dataset.loading === 'true'){
            return false;
        }
        let client = new HttpClient();
        let path = event.currentTarget.dataset.path;
        event.currentTarget.dataset.loading = 'true';

        console.log('[TopFinderPro] removeDevice: path', path);
        console.log('[TopFinderPro] removeDevice: window.csrf', window.csrf);

        client.get(path, (responseText, request) => {
            if (request.status >= 400) {
                console.error('[TopFinderPro] removeDevice error:', responseText);
            }
            TopdataTopFinderProDevice.deviceRemoved(responseText);
        });
        event.currentTarget.dataset.loading = 'false';
    }

    static deviceAdded(data){
        let elements;
        console.log('add Device');
        data = JSON.parse(data);
        elements = document.querySelectorAll('.topdata-finder-popup-button-devicelist-show');
        if(elements !== null) {
            elements.forEach((element) => {element.dataset.loading = 'false';});
        }

        if(data.success===true) {
            //---------------------------------------------------------------
            elements = document.querySelectorAll('.top-finder-add-device-'+data.deviceId);
            if(elements !== null) {
                elements.forEach((element) => {element.style.display='none';});
            }
            elements = document.querySelectorAll('.top-finder-remove-device-'+data.deviceId);
            if(elements !== null) {
                elements.forEach((element) => {element.style.display='block';});
            }
            elements = document.querySelectorAll('.top-finder-devicelist-device-'+data.deviceId);
            if(elements !== null) {
                elements.forEach((element) => {element.style.display='block';});
            }
            elements = document.querySelectorAll('.top-finder-device-list-icon-'+data.deviceId);
            if(elements !== null) {
                elements.forEach((element) => {element.style.display='block';});
            }
            //---------------------------------------------------------------
            // PopUpFinder
            elements = document.querySelectorAll('.topdata-finder-popup-device-add-list-'+data.deviceId);
            if(elements !== null) {
                elements.forEach((element) => {element.classList.add('top-finder-hidden');});
            }
            elements = document.querySelectorAll('.topdata-finder-popup-device-show-list-'+data.deviceId);
            if(elements !== null) {
                elements.forEach((element) => {element.classList.remove('top-finder-hidden');});
            }
            elements = document.querySelectorAll('.topdata-finder-popup-device-remove-list-'+data.deviceId);
            if(elements !== null) {
                elements.forEach((element) => {element.classList.remove('top-finder-hidden');});
            }
            //---------------------------------------------------------------


            let container = document.querySelector('.topdata-finder-popup-content-right');
            if(container !== null){

                if(container.querySelector('.device-box') !== null){

                    elements = container.querySelectorAll('.device-box .device-list-'+data.deviceId);
                    if(elements !== null) {
                        elements.forEach((element) => {element.classList.remove('top-finder-hidden');});
                    }

                    elements = document.querySelectorAll('.topdata-finder-popup-button-devicelist-remove');
                    if(elements !== null) {
                        elements.forEach((element) => {
                            element.classList.remove('hidden');
                            element.classList.remove('inactive');
                        });
                    }

                    elements = document.querySelectorAll('.topdata-finder-popup-button-devicelist-add');
                    if(elements !== null) {
                        elements.forEach((element) => {
                            element.classList.add('hidden');
                            element.classList.add('inactive');
                        });
                    }
                }
            }

        }
    }

    static deviceRemoved(data) {
        let elements;
        console.log('remove Device');
        data = JSON.parse(data);
        elements = document.querySelectorAll('.top-finder-remove-device');
        if (elements !== null) {
            elements.forEach((element) => {
                element.dataset.loading = 'false';
            });
        }
        if (data.success === true) {
            //---------------------------------------------------------------
            elements = document.querySelectorAll('.top-finder-add-device-' + data.deviceId);
            if (elements !== null) {
                elements.forEach((element) => {
                    element.style.display = 'block';
                });
            }
            elements = document.querySelectorAll('.top-finder-remove-device-' + data.deviceId);
            if (elements !== null) {
                elements.forEach((element) => {
                    element.style.display = 'none';
                });
            }
            elements = document.querySelectorAll('.top-finder-devicelist-device-' + data.deviceId);
            if (elements !== null) {
                elements.forEach((element) => {
                    element.style.display = 'none';
                });
            }
            elements = document.querySelectorAll('.top-finder-device-list-icon-' + data.deviceId);
            if (elements !== null) {
                elements.forEach((element) => {
                    element.style.display = 'none';
                });
            }

            // $(TOP_FINDER_SELECTOR+'user-device-list '+TOP_FINDER_SELECTOR+'device-'+data.deviceId).remove();

            //---------------------------------------------------------------
            // PopUpFinder
            elements = document.querySelectorAll('.topdata-finder-popup-content-abc-devices .devicelist-device-' + data.deviceId);
            if (elements !== null) {
                elements.forEach((element) => {
                    element.remove();
                });
            }
            elements = document.querySelectorAll('.topdata-finder-popup-device-add-list-' + data.deviceId);
            if (elements !== null) {
                elements.forEach((element) => {
                    element.classList.remove('top-finder-hidden');
                });
            }
            elements = document.querySelectorAll('.topdata-finder-popup-device-show-list-' + data.deviceId);
            if (elements !== null) {
                elements.forEach((element) => {
                    element.classList.add('top-finder-hidden');
                });
            }
            elements = document.querySelectorAll('.topdata-finder-popup-device-remove-list-' + data.deviceId);
            if (elements !== null) {
                elements.forEach((element) => {
                    element.classList.add('top-finder-hidden');
                });
            }

            //---------------------------------------------------------------

            let container = document.querySelector('.topdata-finder-popup-content-right');
            if (container !== null) {
                if (container.querySelector('.device-box') !== null) {

                    elements = document.querySelectorAll('.topdata-finder-popup-button-devicelist-remove');
                    if (elements !== null) {
                        elements.forEach((element) => {
                            element.classList.add('hidden');
                            element.classList.add('inactive');
                        });
                    }

                    elements = document.querySelectorAll('.topdata-finder-popup-button-devicelist-add');
                    if (elements !== null) {
                        elements.forEach((element) => {
                            element.classList.remove('hidden');
                            element.classList.remove('inactive');
                        });
                    }
                    window.popupDeviceReturnPath = '';
                    elements = container.querySelectorAll('.return');
                    if (elements !== null) {
                        elements.forEach((element) => {
                            element.classList.add('top-finder-hidden');
                            element.dataset.path = '';
                        });
                    }

                    elements = container.querySelector('.device-box .device-list-' + data.deviceId);
                    if (elements !== null) {
                        elements.classList.add('top-finder-hidden');
                    }
                }
            }

        }
    }

}
