// Register them via the existing PluginManager
const PluginManager = window.PluginManager;

import TopdataTopFinderProSearchDevice from './plugin/topdata-top-finder-pro.search-device.plugin';
import TopdataTopFinderProProductDetailDeviceTab from "./plugin/topdata-top-finder-pro.product-detail-device-tab.plugin";
import TopdataTopFinderProFinder from "./plugin/topdata-top-finder-pro.finder.plugin.js";
import TopdataTopFinderProPopupFinder from "./plugin/topdata-top-finder-pro.popup-finder.plugin.js";
import TopdataTopFinderProDeviceSlider from "./plugin/topdata-top-finder-pro.device-slider.plugin";
import TopdataTopFinderProDeviceWrapper from "./plugin/topdata-top-finder-pro.device-wrapper.plugin";
import TopdataTopFinderProDeviceList from "./plugin/topdata-top-finder-pro.device-list.plugin";
import TopdataTopFinderProDevice from "./plugin/topdata-top-finder-pro.device.class"; // Added import


PluginManager.register(
    'TopdataTopFinderProSearchDevice',
    TopdataTopFinderProSearchDevice,
    '[data-search-device-form]'
);


PluginManager.register(
    'TopdataTopFinderProProductDetailDeviceTab',
    TopdataTopFinderProProductDetailDeviceTab,
    '.top-finder-product-devices-load-tab'
);
//
PluginManager.register(
    'TopdataTopFinderProFinder',
    TopdataTopFinderProFinder,
    '.topdata-top-finder-pro-container'
);

PluginManager.register(
    'TopdataTopFinderProPopupFinder',
    TopdataTopFinderProPopupFinder,
    '#topdata-finder-popup'
);

PluginManager.register(
    'TopdataTopFinderProDeviceSlider',
    TopdataTopFinderProDeviceSlider,
    '.top-finder-devices-slider'
);

PluginManager.register(
    'TopdataTopFinderProDeviceList',
    TopdataTopFinderProDeviceList,
    '.account-device-list'
);


PluginManager.register(
    'TopdataTopFinderProDeviceWrapper',
    TopdataTopFinderProDeviceWrapper,
    '.topfinder-device-wrapper'
);


// --- Event listeners for Add/Remove Device Buttons ---
document.addEventListener('DOMContentLoaded', () => {
    const addDeviceButtons = document.querySelectorAll('.top-finder-add-device');
    addDeviceButtons.forEach(button => {
        button.addEventListener('click', (event) => {
            TopdataTopFinderProDevice.addDevice(event);
        });
    });

    const removeDeviceButtons = document.querySelectorAll('.top-finder-remove-device');
    removeDeviceButtons.forEach(button => {
        button.addEventListener('click', (event) => {
            const confirmationMessage = event.currentTarget.dataset.confirm;
            if (confirmationMessage) {
                if (window.confirm(confirmationMessage)) {
                    TopdataTopFinderProDevice.removeDevice(event);
                }
            } else {
                TopdataTopFinderProDevice.removeDevice(event);
            }
        });
    });
});
